/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.FloatingFlowerVariant;
import vazkii.botania.common.lib.BotaniaTags;

public class GrassSeedsItem
extends Item
implements FloatingFlowerVariant {
    private static final Map<ResourceKey<Level>, Set<BlockSwapper>> blockSwappers = new HashMap<ResourceKey<Level>, Set<BlockSwapper>>();
    private static final Map<FloatingFlower.IslandType, Integer> COLORS = ImmutableMap.builder().put((Object)FloatingFlower.IslandType.GRASS, (Object)26112).put((Object)FloatingFlower.IslandType.PODZOL, (Object)8412672).put((Object)FloatingFlower.IslandType.MYCEL, (Object)6160468).put((Object)FloatingFlower.IslandType.DRY, (Object)6717453).put((Object)FloatingFlower.IslandType.GOLDEN, (Object)12563200).put((Object)FloatingFlower.IslandType.VIVID, (Object)32794).put((Object)FloatingFlower.IslandType.SCORCHED, (Object)0xBF0000).put((Object)FloatingFlower.IslandType.INFUSED, (Object)35980).put((Object)FloatingFlower.IslandType.MUTATED, (Object)0x661A66).build();
    private final FloatingFlower.IslandType type;

    public GrassSeedsItem(FloatingFlower.IslandType type, Item.Properties props) {
        super(props);
        this.type = type;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        return this.applySeeds(world, pos, stack);
    }

    public InteractionResult applySeeds(Level world, BlockPos pos, ItemStack stack) {
        BlockState state = world.getBlockState(pos);
        if (state.is(BotaniaTags.Blocks.PASTURE_SEED_REPLACEABLE) && state != GrassSeedsItem.stateForType(this.type)) {
            if (!world.isClientSide) {
                BlockSwapper swapper = GrassSeedsItem.addBlockSwapper(world, pos, this.type);
                world.setBlockAndUpdate(pos, swapper.stateToSet);
                stack.shrink(1);
            } else {
                int color = GrassSeedsItem.getColor(this.type);
                GrassSeedsItem.spawnParticles(world, pos, GrassSeedsItem.extractR(color), GrassSeedsItem.extractG(color), GrassSeedsItem.extractB(color));
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public static void spawnParticles(Level world, BlockPos pos, float r, float g, float b) {
        for (int i = 0; i < 50; ++i) {
            double x = (Math.random() - 0.5) * 3.0;
            double y = Math.random() - 0.5 + 1.0;
            double z = (Math.random() - 0.5) * 3.0;
            float velMul = 0.025f;
            float motionx = (float)(-x) * velMul;
            float motiony = (float)(-y) * velMul;
            float motionz = (float)(-z) * velMul;
            WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, r, g, b);
            world.addParticle((ParticleOptions)data, (double)pos.getX() + 0.5 + x, (double)pos.getY() + 0.5 + y, (double)pos.getZ() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
        }
    }

    public static void onTickEnd(ServerLevel world) {
        ResourceKey dim = world.dimension();
        if (blockSwappers.containsKey(dim)) {
            blockSwappers.get(dim).removeIf(next -> next == null || !next.tick());
        }
    }

    private static BlockSwapper addBlockSwapper(Level world, BlockPos pos, FloatingFlower.IslandType type) {
        BlockSwapper swapper = new BlockSwapper(world, pos, GrassSeedsItem.stateForType(type));
        ResourceKey dim = world.dimension();
        blockSwappers.computeIfAbsent((ResourceKey<Level>)dim, d -> new HashSet()).add(swapper);
        return swapper;
    }

    private static BlockState stateForType(FloatingFlower.IslandType type) {
        if (type == FloatingFlower.IslandType.PODZOL) {
            return Blocks.PODZOL.defaultBlockState();
        }
        if (type == FloatingFlower.IslandType.MYCEL) {
            return Blocks.MYCELIUM.defaultBlockState();
        }
        if (type == FloatingFlower.IslandType.DRY) {
            return BotaniaBlocks.dryGrass.defaultBlockState();
        }
        if (type == FloatingFlower.IslandType.GOLDEN) {
            return BotaniaBlocks.goldenGrass.defaultBlockState();
        }
        if (type == FloatingFlower.IslandType.VIVID) {
            return BotaniaBlocks.vividGrass.defaultBlockState();
        }
        if (type == FloatingFlower.IslandType.SCORCHED) {
            return BotaniaBlocks.scorchedGrass.defaultBlockState();
        }
        if (type == FloatingFlower.IslandType.INFUSED) {
            return BotaniaBlocks.infusedGrass.defaultBlockState();
        }
        if (type == FloatingFlower.IslandType.MUTATED) {
            return BotaniaBlocks.mutatedGrass.defaultBlockState();
        }
        return Blocks.GRASS_BLOCK.defaultBlockState();
    }

    public static float extractR(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float extractG(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float extractB(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static int getColor(FloatingFlower.IslandType type) {
        return COLORS.get(type);
    }

    @Override
    public FloatingFlower.IslandType getIslandType(ItemStack stack) {
        return this.type;
    }

    private static class BlockSwapper {
        public static final int RANGE = 3;
        public static final int TICK_RANGE_HORIZONTAL = 1;
        public static final int TICK_RANGE_VERTICAL = 2;
        private final Level world;
        private final Random rand;
        private final BlockState stateToSet;
        private final BlockPos startCoords;
        private int ticksExisted = 0;

        public BlockSwapper(Level world, BlockPos coords, BlockState state) {
            this.world = world;
            this.stateToSet = state;
            this.rand = new Random(coords.hashCode());
            this.startCoords = coords;
        }

        public boolean tick() {
            if (++this.ticksExisted % 20 == 0) {
                ArrayList<BlockPos> tickPositions = new ArrayList<BlockPos>();
                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.startCoords.offset(-3, -3, -3), (BlockPos)this.startCoords.offset(3, 3, 3))) {
                    if (this.world.getBlockState(pos) != this.stateToSet || !this.canPropagate(pos)) continue;
                    tickPositions.add(pos.immutable());
                }
                tickPositions.forEach(this::tickBlock);
            }
            return this.ticksExisted < 80;
        }

        public void tickBlock(BlockPos pos) {
            ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
            for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -2, -1), (BlockPos)pos.offset(1, 2, 1))) {
                if (targetPos.equals((Object)pos) || this.world.getBlockState(targetPos) == this.stateToSet || !this.isValidSwapPosition(targetPos)) continue;
                validCoords.add(targetPos.immutable());
            }
            if (!validCoords.isEmpty()) {
                BlockPos toSwap = (BlockPos)validCoords.get(this.rand.nextInt(validCoords.size()));
                this.world.setBlockAndUpdate(toSwap, this.stateToSet);
            }
        }

        public boolean isValidSwapPosition(BlockPos pos) {
            BlockState state = this.world.getBlockState(pos);
            return state.is(BotaniaTags.Blocks.PASTURE_SEED_REPLACEABLE) && this.canBeGrass(pos, state);
        }

        private boolean canBeGrass(BlockPos pos, BlockState state) {
            BlockPos abovePos = pos.above();
            BlockState aboveState = this.world.getBlockState(abovePos);
            if (aboveState.is(Blocks.SNOW) && (Integer)aboveState.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
                return true;
            }
            if (aboveState.getFluidState().getAmount() == 8) {
                return false;
            }
            int lightLevel = LightEngine.getLightBlockInto((BlockGetter)this.world, (BlockState)state, (BlockPos)pos, (BlockState)aboveState, (BlockPos)abovePos, (Direction)Direction.UP, (int)aboveState.getLightBlock((BlockGetter)this.world, abovePos));
            return lightLevel < this.world.getMaxLightLevel();
        }

        private boolean canPropagate(BlockPos pos) {
            BlockPos abovePos = pos.above();
            return this.canBeGrass(pos, this.stateToSet) && !this.world.getFluidState(abovePos).is(FluidTags.WATER);
        }
    }
}

