/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class VecHelper {
    public static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);

    private VecHelper() {
    }

    public static Vec3 fromEntityCenter(Entity e) {
        return new Vec3(e.getX(), e.getY() + (double)(e.getBbHeight() / 2.0f), e.getZ());
    }

    public static Vec3 rotate(Vec3 v, double theta, Vec3 axis) {
        if (Mth.equal((double)theta, (double)0.0)) {
            return v;
        }
        Vec3 k = axis.normalize();
        float cosTheta = Mth.cos((float)((float)theta));
        Vec3 firstTerm = v.scale((double)cosTheta);
        Vec3 secondTerm = k.cross(v).scale((double)Mth.sin((float)((float)theta)));
        Vec3 thirdTerm = k.scale(k.dot(v) * (double)(1.0f - cosTheta));
        return new Vec3(firstTerm.x + secondTerm.x + thirdTerm.x, firstTerm.y + secondTerm.y + thirdTerm.y, firstTerm.z + secondTerm.z + thirdTerm.z);
    }

    public static AABB boxForRange(Vec3 v, double range) {
        return VecHelper.boxForRange(v, range, range, range);
    }

    public static AABB boxForRange(Vec3 v, double rangeX, double rangeY, double rangeZ) {
        return new AABB(v.x - rangeX, v.y - rangeY, v.z - rangeZ, v.x + rangeX, v.y + rangeY, v.z + rangeZ);
    }

    public static float toRadians(float degrees) {
        return (float)((double)(degrees / 180.0f) * Math.PI);
    }

    public static Quaternionf rotateX(float degrees) {
        return new Quaternionf().rotateX(VecHelper.toRadians(degrees));
    }

    public static Quaternionf rotateY(float degrees) {
        return new Quaternionf().rotateY(VecHelper.toRadians(degrees));
    }

    public static Quaternionf rotateZ(float degrees) {
        return new Quaternionf().rotateZ(VecHelper.toRadians(degrees));
    }
}

