/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.BotaniaSounds;

public class WorldSeedItem
extends Item {
    public WorldSeedItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        boolean inRange;
        ItemStack stack = player.getItemInHand(hand);
        BlockPos coords = world.getSharedSpawnPos();
        boolean bl = inRange = coords.distToCenterSqr(player.getX(), player.getY(), player.getZ()) <= 576.0;
        if (world.dimension() == Level.OVERWORLD && !inRange) {
            if (!world.isClientSide) {
                Vec3 sourcePos = player.position();
                player.setXRot(0.0f);
                player.setYRot(0.0f);
                player.teleportTo((double)coords.getX() + 0.5, (double)coords.getY() + 0.5, (double)coords.getZ() + 0.5);
                while (!world.noCollision((Entity)player, player.getBoundingBox())) {
                    player.teleportTo(player.getX(), player.getY() + 1.0, player.getZ());
                }
                world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.worldSeedTeleport, SoundSource.PLAYERS, 1.0f, 1.0f);
                SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 0.25f, 1.0f, 0.25f, 10);
                ((ServerLevel)world).sendParticles((ParticleOptions)data, player.getX(), player.getY() + (double)(player.getBbHeight() / 2.0f), player.getZ(), 50, (double)(player.getBbWidth() / 8.0f), (double)(player.getBbHeight() / 4.0f), (double)(player.getBbWidth() / 8.0f), 0.0);
                stack.shrink(1);
                world.gameEvent((Entity)player, GameEvent.TELEPORT, sourcePos);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }
}

