/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ItemBackedInventory
extends SimpleContainer {
    private static final String TAG_ITEMS = "Items";
    private final ItemStack stack;

    public ItemBackedInventory(ItemStack stack, int expectedSize) {
        super(expectedSize);
        this.stack = stack;
        ListTag lst = ItemNBTHelper.getList(stack, TAG_ITEMS, 10, false);
        for (int i = 0; i < expectedSize && i < lst.size(); ++i) {
            this.setItem(i, ItemStack.of((CompoundTag)lst.getCompound(i)));
        }
    }

    public boolean stillValid(Player player) {
        return !this.stack.isEmpty();
    }

    public void setChanged() {
        super.setChanged();
        ListTag list = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            list.add((Object)this.getItem(i).save(new CompoundTag()));
        }
        ItemNBTHelper.setList(this.stack, TAG_ITEMS, list);
    }
}

