/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.CacophoniumBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.mixin.MobAccessor;

public class CacophoniumItem
extends Item {
    private static final String TAG_SOUND = "sound";
    private static final String TAG_SOUND_NAME = "soundName";

    public CacophoniumItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Mob) {
            Slime slime;
            Mob living = (Mob)entity;
            SoundEvent sound = null;
            sound = living instanceof Creeper ? SoundEvents.CREEPER_PRIMED : (living instanceof Slime ? ((slime = (Slime)living).isTiny() ? SoundEvents.SLIME_SQUISH_SMALL : SoundEvents.SLIME_SQUISH) : ((MobAccessor)living).botania_getAmbientSound());
            if (sound != null) {
                if (!player.level().isClientSide) {
                    ItemNBTHelper.setString(stack, TAG_SOUND, BuiltInRegistries.SOUND_EVENT.getKey((Object)sound).toString());
                    ItemNBTHelper.setString(stack, TAG_SOUND_NAME, entity.getType().getDescriptionId());
                    player.setItemInHand(hand, stack);
                }
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos;
        Level world;
        Block block;
        ItemStack stack = ctx.getItemInHand();
        if (CacophoniumItem.getSound(stack) != null && (block = (world = ctx.getLevel()).getBlockState(pos = ctx.getClickedPos()).getBlock()) instanceof NoteBlock) {
            if (!world.isClientSide()) {
                world.setBlockAndUpdate(pos, BotaniaBlocks.cacophonium.defaultBlockState());
                ((CacophoniumBlockEntity)world.getBlockEntity((BlockPos)pos)).stack = stack.copy();
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        if (CacophoniumItem.isDOIT(stack)) {
            list.add((Component)Component.translatable((String)"botaniamisc.justDoIt").withStyle(ChatFormatting.GRAY));
        } else if (CacophoniumItem.getSound(stack) != null) {
            list.add((Component)Component.translatable((String)ItemNBTHelper.getString(stack, TAG_SOUND_NAME, "")).withStyle(ChatFormatting.GRAY));
        }
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (CacophoniumItem.getSound(stack) != null) {
            return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void onUseTick(Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int count) {
        if (!world.isClientSide && count % (CacophoniumItem.isDOIT(stack) ? 20 : 6) == 0) {
            CacophoniumItem.playSound(living.level(), stack, living.getX(), living.getY(), living.getZ(), living.getSoundSource(), 0.9f);
            living.gameEvent(GameEvent.INSTRUMENT_PLAY);
        }
    }

    public static void playSound(Level world, ItemStack stack, double x, double y, double z, SoundSource category, float volume) {
        if (stack.isEmpty()) {
            return;
        }
        SoundEvent sound = CacophoniumItem.getSound(stack);
        if (sound != null) {
            world.playSound(null, x, y, z, sound, category, volume, sound == BotaniaSounds.doit ? 1.0f : (world.random.nextFloat() - world.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Nullable
    @VisibleForTesting
    public static SoundEvent getSound(ItemStack stack) {
        if (CacophoniumItem.isDOIT(stack)) {
            return BotaniaSounds.doit;
        }
        try {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation(ItemNBTHelper.getString(stack, TAG_SOUND, "")));
        }
        catch (ResourceLocationException ex) {
            return null;
        }
    }

    private static boolean isDOIT(ItemStack stack) {
        return !stack.isEmpty() && stack.getHoverName().getString().equalsIgnoreCase("shia labeouf");
    }
}

