/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.mixin.WitherEntityAccessor;

public class PinkWitherEntity
extends WitherBoss {
    public PinkWitherEntity(EntityType<PinkWitherEntity> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.getAvailableGoals().removeIf(entry -> entry.getGoal() instanceof RangedAttackGoal);
        this.targetSelector.getAvailableGoals().removeIf(entry -> entry.getGoal() instanceof HurtByTargetGoal || entry.getGoal() instanceof NearestAttackableTargetGoal);
    }

    public void aiStep() {
        super.aiStep();
        if (Math.random() < 0.1) {
            for (int j = 0; j < 3; ++j) {
                double x = ((WitherEntityAccessor)((Object)this)).botania_getHeadX(j);
                double y = ((WitherEntityAccessor)((Object)this)).botania_getHeadY(j);
                double z = ((WitherEntityAccessor)((Object)this)).botania_getHeadZ(j);
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, x + this.random.nextGaussian() * 0.3, y + this.random.nextGaussian() * 0.3, z + this.random.nextGaussian() * 0.3, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void dropCustomDeathLoot(DamageSource source, int lootingMultiplier, boolean allowDrops) {
    }

    public void customServerAiStep() {
        if (this.tickCount % 20 == 0) {
            this.heal(1.0f);
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void startSeenByPlayer(@NotNull ServerPlayer player) {
    }
}

