/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class WandOfTheForestRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<WandOfTheForestRecipe> SERIALIZER = new Serializer();

    public WandOfTheForestRecipe(ShapedRecipe compose) {
        super(compose.getId(), compose.getGroup(), compose.category(), compose.getWidth(), compose.getHeight(), compose.getIngredients(), compose.getResultItem((RegistryAccess)RegistryAccess.EMPTY));
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, @NotNull RegistryAccess registries) {
        int first = -1;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            int colorId;
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item instanceof MysticalPetalItem) {
                MysticalPetalItem petal = (MysticalPetalItem)item;
                colorId = petal.color.getId();
            } else {
                BlockItem block;
                Block block2;
                if (!(item instanceof BlockItem) || !((block2 = (block = (BlockItem)item).getBlock()) instanceof BotaniaMushroomBlock)) continue;
                BotaniaMushroomBlock mushroom = (BotaniaMushroomBlock)block2;
                colorId = mushroom.color.getId();
            }
            if (first == -1) {
                first = colorId;
                continue;
            }
            return WandOfTheForestItem.setColors(this.getResultItem(registries).copy(), first, colorId);
        }
        return WandOfTheForestItem.setColors(this.getResultItem(registries).copy(), first != -1 ? first : 0, 0);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements RecipeSerializer<WandOfTheForestRecipe> {
        private Serializer() {
        }

        @NotNull
        public WandOfTheForestRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            return new WandOfTheForestRecipe((ShapedRecipe)SHAPED_RECIPE.fromJson(recipeId, json));
        }

        @NotNull
        public WandOfTheForestRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return new WandOfTheForestRecipe((ShapedRecipe)SHAPED_RECIPE.fromNetwork(recipeId, buffer));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull WandOfTheForestRecipe recipe) {
            SHAPED_RECIPE.toNetwork(buffer, (Recipe)recipe);
        }
    }
}

