/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.item.SortableTool;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.mixin.ServerPlayerGameModeAccessor;

public class RingOfCorrectionItem
extends BaubleItem {
    public RingOfCorrectionItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity entity) {
        SortableTool tool;
        ItemStack currentStack;
        ServerPlayer player;
        block8: {
            block7: {
                Item item;
                if (entity.level().isClientSide || !(entity instanceof ServerPlayer)) {
                    return;
                }
                player = (ServerPlayer)entity;
                currentStack = player.getMainHandItem();
                if (currentStack.isEmpty() || !((item = currentStack.getItem()) instanceof SortableTool)) break block7;
                tool = (SortableTool)item;
                if (((ServerPlayerGameModeAccessor)player.gameMode).botania_isDestroyingBlock()) break block8;
            }
            return;
        }
        BlockHitResult pos = ToolCommons.raytraceFromEntity((Entity)player, 4.5, false);
        if (pos.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockState state = entity.level().getBlockState(pos.getBlockPos());
        ItemStack bestTool = currentStack;
        int bestToolPriority = currentStack.getDestroySpeed(state) > 1.0f ? tool.getSortingPriority(currentStack, state) : -1;
        int bestSlot = -1;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            int priority;
            Item item;
            ItemStack stackInSlot = player.getInventory().getItem(i);
            if (stackInSlot.isEmpty() || !((item = stackInSlot.getItem()) instanceof SortableTool)) continue;
            SortableTool toolInSlot = (SortableTool)item;
            if (stackInSlot == currentStack || !(stackInSlot.getDestroySpeed(state) > 1.0f) || (priority = toolInSlot.getSortingPriority(stackInSlot, state)) <= bestToolPriority) continue;
            bestTool = stackInSlot;
            bestToolPriority = priority;
            bestSlot = i;
        }
        if (bestSlot != -1) {
            player.setItemInHand(InteractionHand.MAIN_HAND, bestTool);
            player.getInventory().setItem(bestSlot, currentStack);
        }
    }
}

