/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.xplat.BotaniaConfig;

public class BoreLens
extends Lens {
    private static final List<List<ItemStack>> HARVEST_TOOLS_BY_LEVEL = List.of(BoreLens.stacks(Items.WOODEN_PICKAXE, Items.WOODEN_AXE, Items.WOODEN_HOE, Items.WOODEN_SHOVEL), BoreLens.stacks(Items.STONE_PICKAXE, Items.STONE_AXE, Items.STONE_HOE, Items.STONE_SHOVEL), BoreLens.stacks(Items.IRON_PICKAXE, Items.IRON_AXE, Items.IRON_HOE, Items.IRON_SHOVEL), BoreLens.stacks(Items.DIAMOND_PICKAXE, Items.DIAMOND_AXE, Items.DIAMOND_HOE, Items.DIAMOND_SHOVEL), BoreLens.stacks(Items.NETHERITE_PICKAXE, Items.NETHERITE_AXE, Items.NETHERITE_HOE, Items.NETHERITE_SHOVEL));

    @Override
    public boolean collideBurst(ManaBurst burst, HitResult rtr, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        boolean canWarp;
        ThrowableProjectile entity = burst.entity();
        Level world = entity.level();
        if (world.isClientSide || rtr.getType() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockPos collidePos = ((BlockHitResult)rtr).getBlockPos();
        BlockState state = world.getBlockState(collidePos);
        ItemStack composite = ((LensItem)stack.getItem()).getCompositeLens(stack);
        boolean warpItems = !composite.isEmpty() && composite.is(BotaniaItems.lensWarp);
        ItemStack sourceLens = burst.getSourceLens();
        boolean bl = canWarp = warpItems || sourceLens.is(BotaniaItems.lensWarp);
        if (canWarp && (state.is(BotaniaBlocks.pistonRelay) || state.is(Blocks.PISTON) || state.is(Blocks.MOVING_PISTON) || state.is(Blocks.PISTON_HEAD))) {
            return false;
        }
        int harvestLevel = BotaniaConfig.common().harvestLevelBore();
        BlockEntity tile = world.getBlockEntity(collidePos);
        float hardness = state.getDestroySpeed((BlockGetter)world, collidePos);
        int mana = burst.getMana();
        BlockPos source = burst.getBurstSourceBlockPos();
        if (!isManaBlock && BoreLens.canHarvest(harvestLevel, state) && hardness != -1.0f && (burst.isFake() || mana >= 24)) {
            if (!burst.hasAlreadyCollidedAt(collidePos) && !burst.isFake()) {
                Vec3 dropPosition;
                BlockEntity blockEntity;
                boolean doWarp;
                List items = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)collidePos, (BlockEntity)tile);
                world.removeBlock(collidePos, false);
                world.gameEvent((Entity)entity, GameEvent.BLOCK_DESTROY, collidePos);
                if (BotaniaConfig.common().blockBreakParticles()) {
                    world.levelEvent(2001, collidePos, Block.getId((BlockState)state));
                }
                boolean sourceless = source.equals((Object)ManaBurst.NO_SOURCE) || !burst.isBurstSourceDimension(world);
                boolean bl2 = doWarp = warpItems && !sourceless;
                if (doWarp && (blockEntity = world.getBlockEntity(source)) instanceof ManaSpreaderBlockEntity) {
                    ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)blockEntity;
                    Vec3 sourceVec = Vec3.atCenterOf((Vec3i)source);
                    float xRot = spreader.getRotationY();
                    float yRot = -(spreader.getRotationX() + 90.0f);
                    Vec3 inverseSpreaderDirection = ManaBurstEntity.calculateBurstVelocity(xRot, yRot).normalize().reverse();
                    dropPosition = sourceVec.add(inverseSpreaderDirection);
                } else {
                    dropPosition = Vec3.atCenterOf((Vec3i)collidePos);
                }
                if (world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                    for (ItemStack stack_ : items) {
                        ItemEntity itemEntity = new ItemEntity(world, dropPosition.x, dropPosition.y, dropPosition.z, stack_);
                        itemEntity.setDefaultPickUpDelay();
                        EntityHelper.addTeleportTicketIfFarAway((Entity)itemEntity, collidePos);
                    }
                }
                burst.setMana(mana - 24);
            }
            shouldKill = false;
        }
        return shouldKill;
    }

    private static List<ItemStack> stacks(Item ... items) {
        return Stream.of(items).map(ItemStack::new).toList();
    }

    public static boolean canHarvest(int harvestLevel, BlockState state) {
        return !BoreLens.getTool(harvestLevel, state).isEmpty();
    }

    public static ItemStack getHarvestToolStack(int harvestLevel, BlockState state) {
        return BoreLens.getTool(harvestLevel, state).copy();
    }

    private static ItemStack getTool(int harvestLevel, BlockState state) {
        if (!state.requiresCorrectToolForDrops()) {
            return HARVEST_TOOLS_BY_LEVEL.get(0).get(0);
        }
        int idx = Math.min(harvestLevel, HARVEST_TOOLS_BY_LEVEL.size() - 1);
        for (ItemStack tool : HARVEST_TOOLS_BY_LEVEL.get(idx)) {
            if (!tool.isCorrectToolForDrops(state)) continue;
            return tool;
        }
        return ItemStack.EMPTY;
    }
}

