/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.PhantomInkableBlock;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;

public class CorporeaCrystalCubeBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor,
Wandable,
PhantomInkableBlock {
    private static final String TAG_REQUEST_TARGET = "requestTarget";
    private static final String TAG_ITEM_COUNT = "itemCount";
    private static final String TAG_LOCK = "lock";
    private static final String TAG_HIDE_COUNT = "hideCount";
    private ItemStack requestTarget = ItemStack.EMPTY;
    private int itemCount = 0;
    private int ticks = 0;
    private int compValue = 0;
    public boolean locked = false;
    public boolean hideCount = false;

    public CorporeaCrystalCubeBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_CRYSTAL_CUBE, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CorporeaCrystalCubeBlockEntity self) {
        ++self.ticks;
        if (self.ticks % 20 == 0) {
            self.updateCount();
        }
    }

    public void setRequestTarget(ItemStack stack) {
        if (!stack.isEmpty() && !this.locked) {
            this.requestTarget = stack.copyWithCount(1);
            this.setChanged();
            this.updateCount();
        }
    }

    public ItemStack getRequestTarget() {
        return this.requestTarget;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void doRequest(Player player) {
        if (this.level.isClientSide) {
            return;
        }
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.isEmpty()) {
            int count = player.isShiftKeyDown() ? this.requestTarget.getMaxStackSize() : 1;
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(this.requestTarget, true);
            this.doCorporeaRequest(matcher, count, spark, (LivingEntity)player);
        }
    }

    private void updateCount() {
        if (this.level.isClientSide) {
            return;
        }
        int sum = 0;
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.isEmpty()) {
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(this.requestTarget, true);
            List<ItemStack> stacks = CorporeaHelper.instance().requestItem(matcher, -1, spark, null, false).stacks();
            for (ItemStack stack : stacks) {
                sum += stack.getCount();
            }
        }
        this.setCount(sum);
    }

    private void setCount(int count) {
        int oldCount = this.itemCount;
        this.itemCount = count;
        if (this.itemCount != oldCount) {
            this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(this.itemCount);
            this.setChanged();
        }
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        CompoundTag cmp = new CompoundTag();
        if (!this.requestTarget.isEmpty()) {
            cmp = this.requestTarget.save(cmp);
        }
        tag.put(TAG_REQUEST_TARGET, (Tag)cmp);
        tag.putInt(TAG_ITEM_COUNT, this.itemCount);
        tag.putBoolean(TAG_LOCK, this.locked);
        tag.putBoolean(TAG_HIDE_COUNT, this.hideCount);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        CompoundTag cmp = tag.getCompound(TAG_REQUEST_TARGET);
        this.requestTarget = ItemStack.of((CompoundTag)cmp);
        this.setCount(tag.getInt(TAG_ITEM_COUNT));
        this.locked = tag.getBoolean(TAG_LOCK);
        this.hideCount = tag.getBoolean(TAG_HIDE_COUNT);
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable LivingEntity entity) {
        if (!this.requestTarget.isEmpty()) {
            List<ItemStack> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
            spark.onItemsRequested(stacks);
            boolean did = false;
            int sum = 0;
            for (ItemStack reqStack : stacks) {
                ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, reqStack);
                this.level.addFreshEntity((Entity)item);
                if (!ItemStack.isSameItem((ItemStack)this.requestTarget, (ItemStack)reqStack)) continue;
                sum += reqStack.getCount();
                did = true;
            }
            if (did) {
                this.setCount(this.getItemCount() - sum);
            }
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.isShiftKeyDown()) {
            this.locked = !this.locked;
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean onPhantomInked(@Nullable Player player, ItemStack stack, Direction side) {
        if (this.hideCount) {
            return false;
        }
        if (!this.level.isClientSide()) {
            if (player == null || !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.hideCount = true;
            this.setChanged();
            this.level.gameEvent(null, GameEvent.BLOCK_CHANGE, this.getBlockPos());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public static class Hud {
        public static void render(GuiGraphics gui, CorporeaCrystalCubeBlockEntity cube) {
            PoseStack ps = gui.pose();
            Minecraft mc = Minecraft.getInstance();
            ProfilerFiller profiler = mc.getProfiler();
            profiler.push("crystalCube");
            ItemStack target = cube.getRequestTarget();
            if (!target.isEmpty()) {
                String nameStr = target.getHoverName().getString();
                String countStr = cube.getItemCount() + "x";
                String lockedStr = I18n.get((String)"botaniamisc.locked", (Object[])new Object[0]);
                int strlen = Math.max(mc.font.width(nameStr), mc.font.width(countStr));
                if (cube.locked) {
                    strlen = Math.max(strlen, mc.font.width(lockedStr));
                }
                int centerX = mc.getWindow().getGuiScaledWidth() / 2;
                int centerY = mc.getWindow().getGuiScaledHeight() / 2;
                ps.pushPose();
                ps.translate((float)centerX, (float)centerY, 0.0f);
                RenderHelper.renderHUDBox(gui, 8, -11, strlen + 32, cube.locked ? 21 : 11);
                gui.drawString(mc.font, nameStr, 30, -9, 0x6666FF);
                gui.drawString(mc.font, countStr, 30, 1, 0xFFFFFF);
                if (cube.locked) {
                    gui.drawString(mc.font, lockedStr, 30, 11, 0xFFAA00);
                }
                gui.renderItem(target, 10, -9);
                ps.popPose();
            }
            profiler.pop();
        }
    }
}

