/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class UseItemSuccessTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("use_item_success");
    public static final UseItemSuccessTrigger INSTANCE = new UseItemSuccessTrigger();

    private UseItemSuccessTrigger() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, @NotNull ContextAwarePredicate playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, ItemPredicate.fromJson((JsonElement)json.get("item")), LocationPredicate.fromJson((JsonElement)json.get("location")));
    }

    public void trigger(ServerPlayer player, ItemStack stack, ServerLevel world, double x, double y, double z) {
        this.trigger(player, instance -> instance.test(stack, world, x, y, z));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final LocationPredicate location;

        public Instance(ContextAwarePredicate playerPred, ItemPredicate count, LocationPredicate indexPos) {
            super(ID, playerPred);
            this.item = count;
            this.location = indexPos;
        }

        @NotNull
        public ResourceLocation getCriterion() {
            return ID;
        }

        boolean test(ItemStack stack, ServerLevel world, double x, double y, double z) {
            return this.item.matches(stack) && this.location.matches(world, x, y, z);
        }

        public ItemPredicate getItem() {
            return this.item;
        }

        public JsonObject serializeToJson(SerializationContext serializationContext) {
            JsonObject json = super.serializeToJson(serializationContext);
            if (this.item != ItemPredicate.ANY) {
                json.add("item", this.item.serializeToJson());
            }
            if (this.location != LocationPredicate.ANY) {
                json.add("location", this.location.serializeToJson());
            }
            return json;
        }

        public LocationPredicate getLocation() {
            return this.location;
        }
    }
}

