/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class MultiCraftingProcessor
implements IComponentProcessor {
    private List<CraftingRecipe> recipes;
    private boolean shapeless = true;
    private int longestIngredientSize = 0;
    private boolean hasCustomHeading;

    public void setup(Level level, IVariableProvider variables) {
        List names = variables.get("recipes").asStream().map(IVariable::asString).collect(Collectors.toList());
        this.recipes = new ArrayList<CraftingRecipe>();
        for (String name : names) {
            CraftingRecipe recipe = (CraftingRecipe)PatchouliUtils.getRecipe(level, RecipeType.CRAFTING, new ResourceLocation(name));
            if (recipe != null) {
                this.recipes.add(recipe);
                if (this.shapeless) {
                    this.shapeless = !(recipe instanceof ShapedRecipe);
                }
                for (Ingredient ingredient : recipe.getIngredients()) {
                    int size = ingredient.getItems().length;
                    if (this.longestIngredientSize >= size) continue;
                    this.longestIngredientSize = size;
                }
                continue;
            }
            BotaniaAPI.LOGGER.warn("Missing crafting recipe " + name);
        }
        this.hasCustomHeading = variables.has("heading");
    }

    public IVariable process(Level level, String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            if (!this.hasCustomHeading) {
                return IVariable.from((Object)this.recipes.get(0).getResultItem(level.registryAccess()).getHoverName());
            }
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            int shapedX = index % 3;
            int shapedY = index / 3;
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (CraftingRecipe recipe : this.recipes) {
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shaped = (ShapedRecipe)recipe;
                    if (shaped.getWidth() < shapedX + 1) {
                        ingredients.add(Ingredient.EMPTY);
                        continue;
                    }
                    int realIndex = index - shapedY * (3 - shaped.getWidth());
                    NonNullList list = recipe.getIngredients();
                    ingredients.add(list.size() > realIndex ? (Ingredient)list.get(realIndex) : Ingredient.EMPTY);
                    continue;
                }
                NonNullList list = recipe.getIngredients();
                ingredients.add(list.size() > index ? (Ingredient)list.get(index) : Ingredient.EMPTY);
            }
            return PatchouliUtils.interweaveIngredients(ingredients, this.longestIngredientSize);
        }
        if (key.equals("output")) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(r -> IVariable.from((Object)r.getResultItem(level.registryAccess()))).collect(Collectors.toList()));
        }
        if (key.equals("shapeless")) {
            return IVariable.wrap((Boolean)this.shapeless);
        }
        return null;
    }
}

