/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.configdata;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;

public class LooniumMobSpawnData
extends WeightedEntry.IntrusiveBase {
    public static final Codec<LooniumMobSpawnData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(msd -> msd.type), (App)Weight.CODEC.fieldOf("weight").forGetter(WeightedEntry.IntrusiveBase::getWeight), (App)Codec.BOOL.optionalFieldOf("spawnAsBaby").forGetter(msd -> Optional.ofNullable(msd.spawnAsBaby)), (App)CompoundTag.CODEC.optionalFieldOf("nbt").forGetter(msd -> Optional.ofNullable(msd.nbt)), (App)ResourceLocation.CODEC.optionalFieldOf("equipmentTable").forGetter(msd -> Optional.ofNullable(msd.equipmentTable)), (App)Codec.list(LooniumMobEffectToApply.CODEC).optionalFieldOf("effectsToApply").forGetter(msd -> Optional.ofNullable(msd.effectsToApply)), (App)Codec.list(LooniumMobAttributeModifier.CODEC).optionalFieldOf("attributeModifiers").forGetter(msd -> Optional.ofNullable(msd.attributeModifiers))).apply((Applicative)instance, LooniumMobSpawnData::create));
    public final EntityType<?> type;
    public final Boolean spawnAsBaby;
    public final CompoundTag nbt;
    public final ResourceLocation equipmentTable;
    public final List<LooniumMobEffectToApply> effectsToApply;
    public final List<LooniumMobAttributeModifier> attributeModifiers;

    private LooniumMobSpawnData(EntityType<?> type, Weight weight, Boolean spawnAsBaby, @Nullable CompoundTag nbt, @Nullable ResourceLocation equipmentTable, @Nullable List<LooniumMobEffectToApply> effectsToApply, @Nullable List<LooniumMobAttributeModifier> attributeModifiers) {
        super(weight);
        this.type = type;
        this.spawnAsBaby = spawnAsBaby;
        this.nbt = nbt != null ? nbt.copy() : null;
        this.equipmentTable = equipmentTable;
        this.effectsToApply = effectsToApply != null ? ImmutableList.copyOf(effectsToApply) : null;
        this.attributeModifiers = attributeModifiers != null ? ImmutableList.copyOf(attributeModifiers) : null;
    }

    public static Builder entityWeight(EntityType<?> type, int weight) {
        return new Builder(type, weight);
    }

    public String toString() {
        return "MobSpawnData{type=" + this.type + ", spawnAsBaby=" + this.spawnAsBaby + ", nbt=" + this.nbt + ", equipmentTable=" + this.equipmentTable + ", effectsToApply=" + this.effectsToApply + ", attributeModifiers=" + this.attributeModifiers + "}";
    }

    private static LooniumMobSpawnData create(EntityType<?> type, Weight weight, Optional<Boolean> spawnAsBaby, Optional<CompoundTag> nbt, Optional<ResourceLocation> equipmentTable, Optional<List<LooniumMobEffectToApply>> effectsToApply, Optional<List<LooniumMobAttributeModifier>> attributeModifiers) {
        return new LooniumMobSpawnData(type, weight, spawnAsBaby.orElse(null), nbt.orElse(null), equipmentTable.orElse(null), effectsToApply.orElse(null), attributeModifiers.orElse(null));
    }

    public static class Builder {
        private final EntityType<?> type;
        private final int weight;
        @Nullable
        private Boolean spawnAsBaby;
        @Nullable
        private CompoundTag nbt;
        @Nullable
        private ResourceLocation equipmentTable;
        @Nullable
        private List<LooniumMobEffectToApply> effectsToApply;
        @Nullable
        private List<LooniumMobAttributeModifier> attributeModifiers;

        private Builder(EntityType<?> type, int weight) {
            this.type = type;
            this.weight = weight;
        }

        public Builder spawnAsBaby() {
            this.spawnAsBaby = true;
            return this;
        }

        public Builder spawnAsAdult() {
            this.spawnAsBaby = false;
            return this;
        }

        public Builder nbt(CompoundTag nbt) {
            this.nbt = nbt;
            return this;
        }

        public Builder equipmentTable(ResourceLocation equipmentTable) {
            this.equipmentTable = equipmentTable;
            return this;
        }

        public Builder effectsToApply(LooniumMobEffectToApply ... effectsToApply) {
            this.effectsToApply = List.of(effectsToApply);
            return this;
        }

        public Builder attributeModifiers(LooniumMobAttributeModifier ... attributeModifiers) {
            this.attributeModifiers = List.of(attributeModifiers);
            return this;
        }

        public LooniumMobSpawnData build() {
            return new LooniumMobSpawnData(this.type, Weight.of((int)this.weight), this.spawnAsBaby, this.nbt, this.equipmentTable, this.effectsToApply, this.attributeModifiers);
        }
    }
}

