/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.BotaniaEntities;

public class PixieEntity
extends FlyingMob {
    private static final EntityDataAccessor<Integer> PIXIE_TYPE = SynchedEntityData.defineId(PixieEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private LivingEntity summoner = null;
    private float damage = 0.0f;
    private MobEffectInstance effect = null;

    public PixieEntity(EntityType<PixieEntity> type, Level world) {
        super(type, world);
    }

    public PixieEntity(Level world) {
        this(BotaniaEntities.PIXIE, world);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(PIXIE_TYPE, (Object)0);
    }

    public void setPixieType(int type) {
        this.entityData.set(PIXIE_TYPE, (Object)type);
    }

    public int getPixieType() {
        return (Integer)this.entityData.get(PIXIE_TYPE);
    }

    public void setProps(LivingEntity target, LivingEntity summoner, int type, float damage) {
        this.setTarget(target);
        this.summoner = summoner;
        this.damage = damage;
        this.setPixieType(type);
    }

    public void setApplyPotionEffect(MobEffectInstance effect) {
        this.effect = effect;
    }

    protected void customServerAiStep() {
        LivingEntity target = this.getTarget();
        if (target != null) {
            double d0 = target.getX() + (double)(target.getBbWidth() / 2.0f) - this.getX();
            double d1 = target.getY() + (double)(target.getBbHeight() / 2.0f) - this.getY();
            double d2 = target.getZ() + (double)(target.getBbWidth() / 2.0f) - this.getZ();
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            float mod = 0.45f;
            if (this.getPixieType() == 1) {
                mod = 0.1f;
            }
            this.setDeltaMovement(d0 / d3 * (double)mod, d1 / d3 * (double)mod, d2 / d3 * (double)mod);
            if (Math.sqrt(d3) < 1.0) {
                if (this.summoner != null) {
                    LivingEntity livingEntity = this.summoner;
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        target.hurt(this.damageSources().playerAttack(player), this.damage);
                    } else {
                        target.hurt(this.damageSources().mobAttack(this.summoner), this.damage);
                    }
                } else {
                    target.hurt(this.damageSources().mobAttack((LivingEntity)this), this.damage);
                }
                if (this.effect != null && !(target instanceof Player)) {
                    target.addEffect(this.effect);
                }
                this.discard();
            }
        }
        this.yBodyRot = -((float)Math.atan2(this.getDeltaMovement().x(), this.getDeltaMovement().z())) * 180.0f / (float)Math.PI;
        this.setYRot(this.yBodyRot);
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        if (this.getPixieType() == 0 && source.getEntity() == this.summoner) {
            return true;
        }
        if (this.getPixieType() == 1 && !(source.getEntity() instanceof Player)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public void baseTick() {
        boolean dark;
        super.baseTick();
        if (!(this.level().isClientSide || this.getTarget() != null && this.tickCount <= 200)) {
            this.discard();
        }
        boolean bl = dark = this.getPixieType() == 1;
        if (this.level().isClientSide) {
            for (int i = 0; i < 4; ++i) {
                float r = dark ? 0.1f : 1.0f;
                float g = dark ? 0.025f : 0.25f;
                float b = dark ? 0.09f : 0.9f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.1f + (float)Math.random() * 0.25f, r, g, b, 12);
                this.level().addParticle((ParticleOptions)data, this.getX() + (Math.random() - 0.5) * 0.25, this.getY() + 0.5 + (Math.random() - 0.5) * 0.25, this.getZ() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.level() != null && this.level().isClientSide && this.getPixieType() == 0) {
            for (int i = 0; i < 12; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle(1.0f + (float)Math.random() * 0.25f, 1.0f, 0.25f, 0.9f, 5);
                this.level().addParticle((ParticleOptions)data, this.getX() + (Math.random() - 0.5) * 0.25, this.getY() + 0.5 + (Math.random() - 0.5) * 0.25, this.getZ() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
        super.remove(reason);
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public boolean canBeLeashed(Player player) {
        return false;
    }
}

