/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.WireframeCoordinateListProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.mixin.client.LevelRendererAccessor;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public final class BoundBlockRenderer {
    private static final MultiBufferSource.BufferSource LINE_BUFFERS = MultiBufferSource.immediateWithBuffers((Map)((Map)Util.make(() -> {
        IdentityHashMap<RenderType, BufferBuilder> ret = new IdentityHashMap<RenderType, BufferBuilder>();
        ret.put(RenderHelper.LINE_1_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_1_NO_DEPTH.bufferSize()));
        ret.put(RenderHelper.LINE_4_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_4_NO_DEPTH.bufferSize()));
        ret.put(RenderHelper.LINE_5_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_5_NO_DEPTH.bufferSize()));
        ret.put(RenderHelper.LINE_8_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_8_NO_DEPTH.bufferSize()));
        return ret;
    })), (BufferBuilder)Tesselator.getInstance().getBuilder());

    private BoundBlockRenderer() {
    }

    public static void onWorldRenderLast(Camera camera, PoseStack ms, Level level) {
        BlockPos coords;
        CoordBoundItem coordBoundItem;
        LocalPlayer player = Minecraft.getInstance().player;
        if (!BotaniaConfig.client().boundBlockWireframe() || player == null || player.level() != level) {
            return;
        }
        ms.pushPose();
        int color = 0xFF000000 | Mth.hsvToRgb((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        if (!player.getMainHandItem().isEmpty() && (coordBoundItem = XplatAbstractions.INSTANCE.findCoordBoundItem(player.getMainHandItem())) != null && (coords = coordBoundItem.getBinding(player.level())) != null) {
            BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.level(), coords, color);
        }
        if (!player.getOffhandItem().isEmpty() && (coordBoundItem = XplatAbstractions.INSTANCE.findCoordBoundItem(player.getOffhandItem())) != null && (coords = coordBoundItem.getBinding(player.level())) != null) {
            BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.level(), coords, color);
        }
        BoundBlockRenderer.renderWireframeProviders(camera, (Container)player.getInventory(), (Player)player, ms, color);
        BoundBlockRenderer.renderWireframeProviders(camera, BotaniaAPI.instance().getAccessoriesInventory((Player)player), (Player)player, ms, color);
        ms.popPose();
        RenderSystem.disableDepthTest();
        LINE_BUFFERS.endBatch();
    }

    private static void renderWireframeProviders(Camera camera, Container inv, Player player, PoseStack ms, int color) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            Item item;
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty() || !((item = stackInSlot.getItem()) instanceof WireframeCoordinateListProvider)) continue;
            WireframeCoordinateListProvider provider = (WireframeCoordinateListProvider)item;
            List<BlockPos> coordsList = provider.getWireframesToDraw(player, stackInSlot);
            for (BlockPos coords : coordsList) {
                BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.level(), coords, color);
            }
            BlockPos coords = provider.getSourceWireframe(player, stackInSlot);
            if (coords == null || coords.getY() == Integer.MIN_VALUE) continue;
            BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.level(), coords, color, true);
        }
    }

    private static void renderBlockOutlineAt(Camera camera, PoseStack ms, MultiBufferSource buffers, Level level, BlockPos pos, int color) {
        BoundBlockRenderer.renderBlockOutlineAt(camera, ms, buffers, level, pos, color, false);
    }

    private static void renderBlockOutlineAt(Camera camera, PoseStack ms, MultiBufferSource buffers, Level level, BlockPos pos, int color, boolean thick) {
        VoxelShape shape = level.getBlockState(pos).getShape((BlockGetter)level, pos);
        if (!shape.isEmpty()) {
            double renderPosX = camera.getPosition().x();
            double renderPosY = camera.getPosition().y();
            double renderPosZ = camera.getPosition().z();
            ms.pushPose();
            ms.translate((double)pos.getX() - renderPosX, (double)pos.getY() - renderPosY, (double)pos.getZ() - renderPosZ);
            VertexConsumer buffer = buffers.getBuffer(thick ? RenderHelper.LINE_5_NO_DEPTH : RenderHelper.LINE_1_NO_DEPTH);
            BoundBlockRenderer.renderBlockOutline(ms, buffer, shape, color);
            buffer = buffers.getBuffer(thick ? RenderHelper.LINE_8_NO_DEPTH : RenderHelper.LINE_4_NO_DEPTH);
            int alpha = 64;
            color = color & 0xFFFFFF | alpha << 24;
            BoundBlockRenderer.renderBlockOutline(ms, buffer, shape, color);
            ms.popPose();
        }
    }

    private static void renderBlockOutline(PoseStack pose, VertexConsumer buffer, VoxelShape shape, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        LevelRendererAccessor.renderShape(pose, buffer, shape, 0.0, 0.0, 0.0, r, g, b, a);
    }
}

