/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;

public class ThornChakramEntity
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.defineId(ThornChakramEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FLARE = SynchedEntityData.defineId(ThornChakramEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> RETURN_TO = SynchedEntityData.defineId(ThornChakramEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_BOUNCES = 16;
    private boolean bounced = false;
    private ItemStack stack = ItemStack.EMPTY;

    public ThornChakramEntity(EntityType<ThornChakramEntity> type, Level world) {
        super(type, world);
    }

    public ThornChakramEntity(LivingEntity e, Level world, ItemStack stack) {
        super(BotaniaEntities.THORN_CHAKRAM, e, world);
        this.stack = stack.copy();
    }

    protected void defineSynchedData() {
        this.entityData.define(BOUNCES, (Object)0);
        this.entityData.define(FLARE, (Object)false);
        this.entityData.define(RETURN_TO, (Object)-1);
    }

    public boolean ignoreExplosion() {
        return true;
    }

    public void tick() {
        Entity thrower;
        Vec3 old = this.getDeltaMovement();
        super.tick();
        if (!this.bounced) {
            this.setDeltaMovement(old);
        }
        this.bounced = false;
        if (this.isReturning() && (thrower = this.getOwner()) != null) {
            Vec3 motion = VecHelper.fromEntityCenter(thrower).subtract(VecHelper.fromEntityCenter((Entity)this)).normalize();
            this.setDeltaMovement(motion);
        }
        if (this.level().isClientSide && this.isFire()) {
            double r = 0.1;
            double m = 0.1;
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + r * (Math.random() - 0.5), this.getY() + r * (Math.random() - 0.5), this.getZ() + r * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5));
            }
        }
        if (!(this.level().isClientSide || this.getTimesBounced() < 16 && this.tickCount <= 60)) {
            thrower = this.getOwner();
            if (thrower == null) {
                this.dropAndKill();
            } else {
                this.setEntityToReturnTo(thrower.getId());
                if (this.distanceToSqr(thrower) < 2.0) {
                    this.dropAndKill();
                }
            }
        }
    }

    private void dropAndKill() {
        ItemStack stack = this.getItemStack();
        ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.level().addFreshEntity((Entity)item);
        this.discard();
    }

    private ItemStack getItemStack() {
        return !this.stack.isEmpty() ? this.stack.copy() : (this.isFire() ? new ItemStack((ItemLike)BotaniaItems.flareChakram) : new ItemStack((ItemLike)BotaniaItems.thornChakram));
    }

    protected void onHit(@NotNull HitResult pos) {
        if (!this.isReturning()) {
            super.onHit(pos);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult hit) {
        super.onHitBlock(hit);
        BlockState state = this.level().getBlockState(hit.getBlockPos());
        if (state.getBlock() instanceof BushBlock || state.is(BlockTags.LEAVES)) {
            return;
        }
        int bounces = this.getTimesBounced();
        if (bounces < 16) {
            Vec3 currentMovementVec = this.getDeltaMovement();
            Direction dir = hit.getDirection();
            Vec3 normalVector = new Vec3((double)dir.getStepX(), (double)dir.getStepY(), (double)dir.getStepZ()).normalize();
            Vec3 movementVec = normalVector.scale(-2.0 * currentMovementVec.dot(normalVector)).add(currentMovementVec);
            this.setDeltaMovement(movementVec);
            this.bounced = true;
            if (!this.level().isClientSide) {
                this.setTimesBounced(this.getTimesBounced() + 1);
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult hit) {
        Entity entity;
        super.onHitEntity(hit);
        if (!this.level().isClientSide && (entity = hit.getEntity()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            if (hit.getEntity() != this.getOwner()) {
                Entity thrower = this.getOwner();
                DamageSource src = this.damageSources().generic();
                if (thrower instanceof Player) {
                    src = this.damageSources().thrown((Entity)this, thrower);
                } else if (thrower instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)thrower;
                    src = this.damageSources().mobAttack(livingEntity);
                }
                hitEntity.hurt(src, 12.0f);
                if (this.isFire()) {
                    hitEntity.setSecondsOnFire(5);
                } else if (this.level().random.nextInt(3) == 0) {
                    hitEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 60, 0));
                }
            }
        }
    }

    protected float getGravity() {
        return 0.0f;
    }

    private int getTimesBounced() {
        return (Integer)this.entityData.get(BOUNCES);
    }

    private void setTimesBounced(int times) {
        this.entityData.set(BOUNCES, (Object)times);
    }

    public boolean isFire() {
        return (Boolean)this.entityData.get(FLARE);
    }

    public void setFire(boolean fire) {
        this.entityData.set(FLARE, (Object)fire);
    }

    private boolean isReturning() {
        return this.getEntityToReturnTo() > -1;
    }

    private int getEntityToReturnTo() {
        return (Integer)this.entityData.get(RETURN_TO);
    }

    private void setEntityToReturnTo(int entityID) {
        this.entityData.set(RETURN_TO, (Object)entityID);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (!this.stack.isEmpty()) {
            compound.put("fly_stack", (Tag)this.stack.save(new CompoundTag()));
        }
        compound.putBoolean("flare", this.isFire());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("fly_stack")) {
            this.stack = ItemStack.of((CompoundTag)compound.getCompound("fly_stack"));
        }
        this.setFire(compound.getBoolean("flare"));
    }

    @NotNull
    public ItemStack getItem() {
        return this.getItemStack();
    }
}

