/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.item.BotaniaItems;

public class ApothecaryRecipeTest {
    private static final String TEMPLATE = "botania:block/apothecary_recipe";
    private static final BlockPos APOTHECARY = new BlockPos(1, 2, 1);

    private void fillApothecary(GameTestHelper helper) {
        BlockState apothecary = helper.getBlockState(APOTHECARY);
        helper.setBlock(APOTHECARY, (BlockState)apothecary.setValue(PetalApothecaryBlock.FLUID, (Comparable)((Object)PetalApothecary.State.WATER)));
    }

    private void spawnItem(GameTestHelper helper, Item item) {
        BlockPos pos = APOTHECARY.above();
        helper.spawnItem(item, (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
    }

    @GameTest(template="botania:block/apothecary_recipe", batch="apothecary")
    public void testItemEnterPrevention(GameTestHelper helper) {
        helper.startSequence().thenExecute(() -> {
            this.spawnItem(helper, BotaniaItems.whitePetal);
            this.spawnItem(helper, BotaniaItems.whitePetal);
            this.spawnItem(helper, BotaniaItems.whitePetal);
            this.spawnItem(helper, BotaniaItems.whitePetal);
        }).thenExecuteAfter(1, () -> this.spawnItem(helper, Items.MELON_SEEDS)).thenExecuteAfter(10, () -> {
            helper.assertItemEntityPresent(BotaniaFlowerBlocks.pureDaisy.asItem(), APOTHECARY.above(), 1.5);
            this.fillApothecary(helper);
            helper.killAllEntities();
            this.spawnItem(helper, Items.MELON_SEEDS);
            this.spawnItem(helper, Items.PUMPKIN_SEEDS);
        }).thenExecuteAfter(10, () -> {
            helper.assertItemEntityPresent(Items.PUMPKIN_SEEDS, APOTHECARY.above(), 1.5);
            helper.assertItemEntityPresent(Items.MELON_SEEDS, APOTHECARY.above(), 1.5);
            this.spawnItem(helper, Items.DIAMOND);
        }).thenExecuteAfter(10, () -> {
            helper.killAllEntities();
            helper.destroyBlock(APOTHECARY);
            helper.assertItemEntityPresent(Items.PUMPKIN_SEEDS, APOTHECARY, 1.5);
            helper.assertItemEntityPresent(Items.MELON_SEEDS, APOTHECARY, 1.5);
            helper.assertItemEntityPresent(Items.DIAMOND, APOTHECARY, 1.5);
            helper.killAllEntities();
        }).thenSucceed();
    }
}

