/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.helper.VecHelper;

public class MagicMissileEntity
extends ThrowableProjectile {
    private static final String TAG_TIME = "time";
    private static final EntityDataAccessor<Boolean> EVIL = SynchedEntityData.defineId(MagicMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.defineId(MagicMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    double lockX;
    double lockY = -2.147483648E9;
    double lockZ;
    int time = 0;

    public MagicMissileEntity(EntityType<MagicMissileEntity> type, Level world) {
        super(type, world);
    }

    public MagicMissileEntity(LivingEntity owner, boolean evil) {
        super(BotaniaEntities.MAGIC_MISSILE, owner, owner.level());
        this.setEvil(evil);
    }

    protected void defineSynchedData() {
        this.entityData.define(EVIL, (Object)false);
        this.entityData.define(TARGET, (Object)0);
    }

    public void setEvil(boolean evil) {
        this.entityData.set(EVIL, (Object)evil);
    }

    public boolean isEvil() {
        return (Boolean)this.entityData.get(EVIL);
    }

    public void setTarget(LivingEntity e) {
        this.entityData.set(TARGET, (Object)(e == null ? -1 : e.getId()));
    }

    public LivingEntity getTargetEntity() {
        int id = (Integer)this.entityData.get(TARGET);
        Entity e = this.level().getEntity(id);
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            return le;
        }
        return null;
    }

    public void tick() {
        double lastTickPosX = this.xOld;
        double lastTickPosY = this.yOld;
        double lastTickPosZ = this.zOld;
        super.tick();
        if (!(this.level().isClientSide || this.findTarget() && this.time <= 40)) {
            this.discard();
            return;
        }
        boolean evil = this.isEvil();
        Vec3 thisVec = VecHelper.fromEntityCenter((Entity)this);
        Vec3 oldPos = new Vec3(lastTickPosX, lastTickPosY, lastTickPosZ);
        Vec3 diff = thisVec.subtract(oldPos);
        Vec3 step = diff.normalize().scale(0.05);
        int steps = (int)(diff.length() / step.length());
        Vec3 particlePos = oldPos;
        SparkleParticleData data = evil ? SparkleParticleData.corrupt(0.8f, 1.0f, 0.0f, 1.0f, 2) : SparkleParticleData.sparkle(0.8f, 1.0f, 0.4f, 1.0f, 2);
        for (int i = 0; i < steps; ++i) {
            this.level().addParticle((ParticleOptions)data, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.0, 0.0);
            if (this.level().random.nextInt(steps) <= 1) {
                this.level().addParticle((ParticleOptions)data, particlePos.x + (Math.random() - 0.5) * 0.4, particlePos.y + (Math.random() - 0.5) * 0.4, particlePos.z + (Math.random() - 0.5) * 0.4, 0.0, 0.0, 0.0);
            }
            particlePos = particlePos.add(step);
        }
        LivingEntity target = this.getTargetEntity();
        if (target != null) {
            List targetList;
            if (this.lockY == -2.147483648E9) {
                this.lockX = target.getX();
                this.lockY = target.getY();
                this.lockZ = target.getZ();
            }
            Vec3 targetVec = evil ? new Vec3(this.lockX, this.lockY, this.lockZ) : VecHelper.fromEntityCenter((Entity)target);
            Vec3 diffVec = targetVec.subtract(thisVec);
            Vec3 motionVec = diffVec.normalize().scale(evil ? 0.5 : 0.6);
            this.setDeltaMovement(motionVec);
            if (this.time < 10) {
                this.setDeltaMovement(this.getDeltaMovement().x(), Math.abs(this.getDeltaMovement().y()), this.getDeltaMovement().z());
            }
            if ((targetList = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.getX() - 0.5, this.getY() - 0.5, this.getZ() - 0.5, this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5))).contains(target)) {
                target.hurt(this.getDamageSource(), evil ? 12.0f : 7.0f);
                this.discard();
            }
            if (evil && diffVec.length() < 1.0) {
                this.discard();
            }
        }
        ++this.time;
    }

    private DamageSource getDamageSource() {
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            DamageSource damageSource;
            LivingEntity livingOwner = (LivingEntity)owner;
            if (owner instanceof Player) {
                Player playerOwner = (Player)owner;
                damageSource = this.damageSources().playerAttack(playerOwner);
            } else {
                damageSource = this.damageSources().mobAttack(livingOwner);
            }
            return damageSource;
        }
        return this.damageSources().generic();
    }

    public void addAdditionalSaveData(CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putInt(TAG_TIME, this.time);
    }

    public void readAdditionalSaveData(CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.time = cmp.getInt(TAG_TIME);
    }

    public boolean findTarget() {
        List entities;
        LivingEntity target = this.getTargetEntity();
        if (target != null) {
            if (target.isAlive()) {
                return true;
            }
            target = null;
            this.setTarget(null);
        }
        double range = 12.0;
        AABB bounds = new AABB(this.getX() - range, this.getY() - range, this.getZ() - range, this.getX() + range, this.getY() + range, this.getZ() + range);
        DamageSource source = this.getDamageSource();
        Predicate<Entity> vulnerableTo = e -> !e.isInvulnerableTo(source);
        if (this.isEvil()) {
            entities = this.level().getEntitiesOfClass(Player.class, bounds, EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(vulnerableTo));
        } else {
            Entity owner = this.getOwner();
            Predicate<Entity> pred = EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(MagicMissileEntity.targetPredicate(owner)).and(vulnerableTo);
            entities = this.level().getEntitiesOfClass(LivingEntity.class, bounds, pred);
        }
        if (!entities.isEmpty()) {
            target = (LivingEntity)entities.get(this.level().random.nextInt(entities.size()));
            this.setTarget(target);
        }
        return target != null;
    }

    public static Predicate<Entity> targetPredicate(Entity owner) {
        return target -> {
            LivingEntity living;
            return target instanceof LivingEntity && MagicMissileEntity.shouldTarget(owner, living = (LivingEntity)target);
        };
    }

    public static boolean shouldTarget(Entity owner, LivingEntity e) {
        AbstractHorse horse;
        TamableAnimal animal;
        Mob mob;
        if (e instanceof Mob && MagicMissileEntity.isHostile(owner, (Entity)(mob = (Mob)e).getTarget())) {
            return true;
        }
        if (e instanceof TamableAnimal && (animal = (TamableAnimal)e).isTame() || e instanceof AbstractHorse && (horse = (AbstractHorse)e).isTamed()) {
            return false;
        }
        return e instanceof Enemy;
    }

    public static boolean isHostile(Entity owner, Entity attackTarget) {
        if (owner instanceof Player) {
            Player targetedPlayer;
            Player ownerPlayer = (Player)owner;
            if (attackTarget instanceof Player && ownerPlayer.canHarmPlayer(targetedPlayer = (Player)attackTarget)) {
                return owner == attackTarget;
            }
        }
        return attackTarget instanceof Player;
    }

    protected void onHitBlock(@NotNull BlockHitResult hit) {
        super.onHitBlock(hit);
        BlockState state = this.level().getBlockState(hit.getBlockPos());
        if (!(this.level().isClientSide || state.getBlock() instanceof BushBlock || state.is(BlockTags.LEAVES))) {
            this.discard();
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult hit) {
        super.onHitEntity(hit);
        if (!this.level().isClientSide && hit.getEntity() == this.getTargetEntity()) {
            this.discard();
        }
    }
}

