/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class OrechidProvider
extends BotaniaRecipeProvider {
    public OrechidProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    protected void buildRecipes(Consumer<FinishedRecipe> consumer) {
        consumer.accept(this.stone(Blocks.COAL_ORE, 67415));
        consumer.accept(this.stone(Blocks.IRON_ORE, 29371));
        consumer.accept(this.stone(Blocks.REDSTONE_ORE, 7654));
        consumer.accept(this.stone(Blocks.COPPER_ORE, 7000));
        consumer.accept(this.stone(Blocks.GOLD_ORE, 2647));
        consumer.accept(this.stone(Blocks.EMERALD_ORE, 1239));
        consumer.accept(this.stone(Blocks.LAPIS_ORE, 1079));
        consumer.accept(this.stone(Blocks.DIAMOND_ORE, 883));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_COAL_ORE, 75));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_IRON_ORE, 250));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_REDSTONE_ORE, 150));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_COPPER_ORE, 75));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_GOLD_ORE, 125));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_EMERALD_ORE, 50));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_LAPIS_ORE, 175));
        consumer.accept(this.deepslate(Blocks.DEEPSLATE_DIAMOND_ORE, 100));
        consumer.accept(this.netherrack(Blocks.NETHER_QUARTZ_ORE, 19600));
        consumer.accept(this.netherrack(Blocks.NETHER_GOLD_ORE, 3635));
        consumer.accept(this.netherrack(Blocks.ANCIENT_DEBRIS, 148));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStoneForest, BotaniaTags.Biomes.MARIMORPHOSIS_FOREST_BONUS));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStonePlains, BotaniaTags.Biomes.MARIMORPHOSIS_PLAINS_BONUS));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStoneMountain, BotaniaTags.Biomes.MARIMORPHOSIS_MOUNTAIN_BONUS));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStoneFungal, BotaniaTags.Biomes.MARIMORPHOSIS_FUNGAL_BONUS));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStoneSwamp, BotaniaTags.Biomes.MARIMORPHOSIS_SWAMP_BONUS));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStoneDesert, BotaniaTags.Biomes.MARIMORPHOSIS_DESERT_BONUS));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStoneTaiga, BotaniaTags.Biomes.MARIMORPHOSIS_TAIGA_BONUS));
        consumer.accept(this.biomeStone(BotaniaBlocks.biomeStoneMesa, BotaniaTags.Biomes.MARIMORPHOSIS_MESA_BONUS));
    }

    protected ResourceLocation orechidId(Block b) {
        return ResourceLocationHelper.prefix("orechid/" + BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    protected ResourceLocation ignemId(Block b) {
        return ResourceLocationHelper.prefix("orechid_ignem/" + BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    protected ResourceLocation marimorphosisId(Block b) {
        return ResourceLocationHelper.prefix("marimorphosis/" + BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    protected Result stone(Block output, int weight) {
        return new Result(BotaniaRecipeTypes.ORECHID_SERIALIZER, this.orechidId(output), OrechidProvider.forBlock(Blocks.STONE), OrechidProvider.forBlock(output), weight);
    }

    protected Result deepslate(Block output, int weight) {
        return new Result(BotaniaRecipeTypes.ORECHID_SERIALIZER, this.orechidId(output), OrechidProvider.forBlock(Blocks.DEEPSLATE), OrechidProvider.forBlock(output), weight);
    }

    protected Result netherrack(Block output, int weight) {
        return new Result(BotaniaRecipeTypes.ORECHID_IGNEM_SERIALIZER, this.ignemId(output), OrechidProvider.forBlock(Blocks.NETHERRACK), OrechidProvider.forBlock(output), weight);
    }

    protected Result biomeStone(Block output, TagKey<Biome> biome) {
        return new BiomeResult(BotaniaRecipeTypes.MARIMORPHOSIS_SERIALIZER, this.marimorphosisId(output), OrechidProvider.forTag(BotaniaTags.Blocks.MARIMORPHOSIS_CONVERTABLE), OrechidProvider.forBlock(output), 1, 11, biome);
    }

    protected static StateIngredient forBlock(Block block) {
        return StateIngredientHelper.of(block);
    }

    protected static StateIngredient forTag(TagKey<Block> tag) {
        return StateIngredientHelper.of(tag);
    }

    public String getName() {
        return "Botania Orechid and Marimorphosis recipes";
    }

    protected static class Result
    implements FinishedRecipe {
        private final RecipeSerializer<? extends OrechidRecipe> type;
        private final ResourceLocation id;
        private final StateIngredient input;
        private final StateIngredient output;
        private final int weight;

        public Result(RecipeSerializer<? extends OrechidRecipe> type, ResourceLocation id, StateIngredient input, StateIngredient output, int weight) {
            this.type = type;
            this.id = id;
            this.input = input;
            this.output = output;
            this.weight = weight;
        }

        public void serializeRecipeData(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.add("output", (JsonElement)this.output.serialize());
            json.addProperty("weight", (Number)this.weight);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return this.type;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }

    protected static class BiomeResult
    extends Result {
        private final int bonusWeight;
        private final TagKey<Biome> biome;

        public BiomeResult(RecipeSerializer<? extends OrechidRecipe> type, ResourceLocation id, StateIngredient input, StateIngredient output, int weight, int bonusWeight, TagKey<Biome> biome) {
            super(type, id, input, output, weight);
            this.bonusWeight = bonusWeight;
            this.biome = biome;
        }

        @Override
        public void serializeRecipeData(JsonObject json) {
            super.serializeRecipeData(json);
            json.addProperty("biome_bonus_tag", this.biome.location().toString());
            json.addProperty("biome_bonus", (Number)this.bonusWeight);
        }
    }
}

