/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.SkullBlock;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.client.core.helper.CoreShaders;

public class GaiaHeadBlockEntityRenderer
extends SkullBlockRenderer {
    public static Map<SkullBlock.Type, SkullModelBase> models = Collections.emptyMap();

    public GaiaHeadBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        models = SkullBlockRenderer.createSkullRenderers((EntityModelSet)ctx.getModelSet());
    }

    public static SkullBlock.Type getViewType() {
        Entity view = Minecraft.getInstance().getCameraEntity();
        SkullBlock.Types type = SkullBlock.Types.PLAYER;
        if (view instanceof Skeleton) {
            type = SkullBlock.Types.SKELETON;
        } else if (view instanceof WitherSkeleton) {
            type = SkullBlock.Types.WITHER_SKELETON;
        } else if (view instanceof WitherBoss) {
            type = SkullBlock.Types.WITHER_SKELETON;
        } else if (view instanceof Zombie) {
            type = SkullBlock.Types.ZOMBIE;
        } else if (view instanceof Creeper) {
            type = SkullBlock.Types.CREEPER;
        } else if (view instanceof EnderDragon) {
            type = SkullBlock.Types.DRAGON;
        }
        return type;
    }

    public static void hookGetRenderType(CallbackInfoReturnable<RenderType> cir) {
        Entity entity;
        SkullBlock.Type type = GaiaHeadBlockEntityRenderer.getViewType();
        GameProfile profile = null;
        if (type == SkullBlock.Types.PLAYER && (entity = Minecraft.getInstance().getCameraEntity()) instanceof Player) {
            Player player = (Player)entity;
            profile = player.getGameProfile();
        }
        RenderType layer = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, profile);
        cir.setReturnValue((Object)new WrapperLayer(layer));
    }

    private static class WrapperLayer
    extends RenderType {
        public WrapperLayer(RenderType compose) {
            super(compose.toString(), compose.format(), compose.mode(), compose.bufferSize(), compose.affectsCrumbling(), false, () -> {
                compose.setupRenderState();
                ShaderInstance shader = CoreShaders.doppleganger();
                if (shader != null) {
                    RenderSystem.setShader(CoreShaders::doppleganger);
                    shader.safeGetUniform("BotaniaDisfiguration").set(0.025f);
                    shader.safeGetUniform("BotaniaGrainIntensity").set(0.05f);
                }
            }, () -> ((RenderType)compose).clearRenderState());
        }
    }
}

