/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class StringObfuscator {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public static boolean matchesHash(String str, String hash) {
        return StringObfuscator.getHash(str).equals(hash);
    }

    private static String getHash(String str) {
        if (str != null) {
            try {
                byte[] bytes;
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                StringBuilder ret = new StringBuilder();
                for (byte b : bytes = md.digest(StringObfuscator.dontRainbowTableMeOrMySonEverAgain(str).getBytes(StandardCharsets.UTF_8))) {
                    ret.append(HEX_CHARS[b >> 4 & 0xF]);
                    ret.append(HEX_CHARS[b & 0xF]);
                }
                return ret.toString();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private static String dontRainbowTableMeOrMySonEverAgain(String str) throws NoSuchAlgorithmException {
        str = (String)str + StringObfuscator.reverseString((String)str);
        SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
        rand.setSeed(((String)str).getBytes(StandardCharsets.UTF_8));
        int l = ((String)str).length();
        int steps = rand.nextInt(l);
        char[] chrs = ((String)str).toCharArray();
        for (int i = 0; i < steps; ++i) {
            char c;
            int indB;
            int indA = rand.nextInt(l);
            while ((indB = rand.nextInt(l)) == indA) {
            }
            chrs[indA] = c = (char)(chrs[indA] ^ chrs[indB]);
        }
        return String.copyValueOf(chrs);
    }

    private static String reverseString(String str) {
        return new StringBuilder(str).reverse().toString();
    }
}

