/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaUpgradeRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<ManaUpgradeRecipe> SERIALIZER = new Serializer();

    public ManaUpgradeRecipe(ShapedRecipe compose) {
        super(compose.getId(), compose.getGroup(), compose.category(), compose.getWidth(), compose.getHeight(), compose.getIngredients(), compose.getResultItem((RegistryAccess)RegistryAccess.EMPTY));
    }

    public static ItemStack output(ItemStack output, Container inv) {
        ItemStack out = output.copy();
        ManaItem outItem = XplatAbstractions.INSTANCE.findManaItem(out);
        if (outItem == null) {
            return out;
        }
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            ManaItem item = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (stack.isEmpty() || item == null) continue;
            outItem.addMana(item.getMana());
        }
        return out;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        return ManaUpgradeRecipe.output(super.assemble(inv, registries), (Container)inv);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements RecipeSerializer<ManaUpgradeRecipe> {
        private Serializer() {
        }

        public ManaUpgradeRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            return new ManaUpgradeRecipe((ShapedRecipe)SHAPED_RECIPE.fromJson(recipeId, json));
        }

        public ManaUpgradeRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return new ManaUpgradeRecipe((ShapedRecipe)SHAPED_RECIPE.fromNetwork(recipeId, buffer));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull ManaUpgradeRecipe recipe) {
            SHAPED_RECIPE.toNetwork(buffer, (Recipe)recipe);
        }
    }
}

