/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.ExoflameHeatable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.XplatAbstractions;

public class ExoflameBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 5;
    private static final int RANGE_Y = 2;
    private static final int COST = 300;

    public ExoflameBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.EXOFLAME, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide || this.getMana() <= 2) {
            return;
        }
        boolean did = false;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getEffectivePos().offset(-5, -2, -5), (BlockPos)this.getEffectivePos().offset(5, 2, 5))) {
            ExoflameHeatable heatable;
            BlockEntity tile = this.getLevel().getBlockEntity(pos);
            if (tile == null || (heatable = XplatAbstractions.INSTANCE.findExoflameHeatable(this.getLevel(), pos, this.getLevel().getBlockState(pos), tile)) == null || !heatable.canSmelt() || this.getMana() < 300) continue;
            if (heatable.getBurnTime() < 2) {
                heatable.boostBurnTime();
                this.addMana(-300);
                did = true;
            }
            if (this.ticksExisted % 2 == 0) {
                heatable.boostCookTime();
            }
            if (this.getMana() > 0) continue;
            break;
        }
        if (did) {
            this.sync();
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public int getMaxMana() {
        return 300;
    }

    @Override
    public int getColor() {
        return 0x661600;
    }
}

