/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

public class CosmeticBaubleItem
extends BaubleItem
implements CosmeticBauble {
    private final Variant variant;

    public CosmeticBaubleItem(Variant variant, Item.Properties props) {
        super(props);
        this.variant = variant;
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        if (this.variant == Variant.THINKING_HAND) {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.cosmeticThinking").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        } else {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.cosmeticBauble").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
        super.appendHoverText(stack, world, tooltip, flags);
    }

    public static enum Variant {
        BLACK_BOWTIE,
        BLACK_TIE,
        RED_GLASSES(true),
        PUFFY_SCARF,
        ENGINEER_GOGGLES(true),
        EYEPATCH(true),
        WICKED_EYEPATCH(true),
        RED_RIBBONS(true),
        PINK_FLOWER_BUD(true),
        POLKA_DOTTED_BOWS(true),
        BLUE_BUTTERFLY(true),
        CAT_EARS(true),
        WITCH_PIN,
        DEVIL_TAIL,
        KAMUI_EYE,
        GOOGLY_EYES(true),
        FOUR_LEAF_CLOVER,
        CLOCK_EYE(true),
        UNICORN_HORN(true),
        DEVIL_HORNS(true),
        HYPER_PLUS(true),
        BOTANIST_EMBLEM,
        ANCIENT_MASK(true),
        EERIE_MASK(true),
        ALIEN_ANTENNA(true),
        ANAGLYPH_GLASSES(true),
        ORANGE_SHADES(true),
        GROUCHO_GLASSES(true),
        THICK_EYEBROWS(true),
        LUSITANIC_SHIELD,
        TINY_POTATO_MASK(true),
        QUESTGIVER_MARK(true),
        THINKING_HAND(true);

        private final boolean isHead;

        private Variant(boolean isHead) {
            this.isHead = isHead;
        }

        private Variant() {
            this(false);
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            Variant variant = ((CosmeticBaubleItem)stack.getItem()).variant;
            if (variant.isHead) {
                bipedModel.head.translateAndRotate(ms);
                switch (variant) {
                    case RED_GLASSES: 
                    case ENGINEER_GOGGLES: 
                    case ANAGLYPH_GLASSES: {
                        ms.translate(0.0, -0.225, -0.3);
                        ms.scale(0.7f, -0.7f, -0.7f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case EYEPATCH: {
                        ms.translate(0.125, -0.225, -0.3);
                        ms.mulPose(VecHelper.rotateY(180.0f));
                        ms.scale(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case WICKED_EYEPATCH: {
                        ms.translate(-0.125, -0.225, -0.3);
                        ms.scale(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case RED_RIBBONS: {
                        ms.translate(0.0, -0.65, 0.2);
                        ms.mulPose(VecHelper.rotateY(180.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case PINK_FLOWER_BUD: {
                        ms.translate(0.275, -0.6, 0.0);
                        ms.mulPose(VecHelper.rotateY(-90.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case POLKA_DOTTED_BOWS: {
                        ms.pushPose();
                        ms.translate(0.275, -0.4, 0.0);
                        ms.mulPose(VecHelper.rotateY(-90.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.popPose();
                        ms.translate(-0.275, -0.4, 0.0);
                        ms.mulPose(VecHelper.rotateY(90.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case BLUE_BUTTERFLY: {
                        ms.pushPose();
                        ms.translate(0.275, -0.4, 0.0);
                        ms.mulPose(VecHelper.rotateY(45.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.popPose();
                        ms.translate(0.275, -0.4, 0.0);
                        ms.mulPose(VecHelper.rotateY(-45.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case CAT_EARS: {
                        ms.translate(0.0f, -0.5f, -0.175f);
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case GOOGLY_EYES: {
                        ms.translate(0.0, -0.225, -0.3);
                        ms.scale(0.9f, -0.9f, -0.9f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case CLOCK_EYE: {
                        ms.translate(0.1, -0.225, (double)-0.3f);
                        ms.scale(0.4f, -0.4f, -0.4f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case UNICORN_HORN: {
                        ms.translate(0.0, -0.7, -0.3);
                        ms.mulPose(VecHelper.rotateY(-90.0f));
                        ms.scale(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case DEVIL_HORNS: {
                        ms.translate(0.0f, -0.4f, -0.175f);
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case HYPER_PLUS: {
                        ms.translate(-0.15f, -0.45f, -0.3f);
                        ms.scale(0.2f, -0.2f, -0.2f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.translate(1.45f, 0.0f, 0.0f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case ANCIENT_MASK: {
                        ms.translate(0.0, -0.3, -0.3);
                        ms.scale(0.7f, -0.7f, -0.7f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case EERIE_MASK: {
                        ms.translate(0.0, -0.25, -0.3);
                        ms.scale(0.75f, -0.75f, -0.75f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case ALIEN_ANTENNA: {
                        ms.translate(0.0, -0.65, 0.2);
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case ORANGE_SHADES: {
                        ms.translate(0.0, -0.3, -0.3);
                        ms.scale(0.7f, -0.7f, -0.7f);
                        int color = -1291845633;
                        RenderHelper.renderItemCustomColor(living, stack, color, ms, buffers, light, OverlayTexture.NO_OVERLAY);
                        break;
                    }
                    case GROUCHO_GLASSES: {
                        ms.translate(0.0, -0.1, -0.3);
                        ms.scale(0.75f, -0.75f, -0.75f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case THICK_EYEBROWS: {
                        ms.pushPose();
                        ms.translate(-0.1, -0.3, -0.3);
                        ms.scale(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.popPose();
                        ms.translate(0.1, -0.3, -0.3);
                        ms.mulPose(VecHelper.rotateY(180.0f));
                        ms.scale(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case TINY_POTATO_MASK: {
                        ms.translate(0.0, -0.3, -0.3);
                        ms.scale(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case QUESTGIVER_MARK: {
                        ms.translate(0.0, -0.8, -0.2);
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case THINKING_HAND: {
                        ms.translate(-0.1, 0.0, -0.3);
                        ms.mulPose(VecHelper.rotateZ(-15.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                }
            } else {
                bipedModel.body.translateAndRotate(ms);
                switch (variant) {
                    case BLACK_BOWTIE: {
                        ms.translate(0.0, 0.1, -0.13);
                        ms.scale(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case BLACK_TIE: 
                    case PUFFY_SCARF: {
                        ms.translate(0.0, 0.25, -0.15);
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case WITCH_PIN: {
                        ms.translate(-0.1, 0.15, -0.15);
                        ms.scale(0.2f, -0.2f, -0.2f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case DEVIL_TAIL: {
                        ms.translate(0.0, 0.55, 0.2);
                        ms.mulPose(VecHelper.rotateY(-90.0f));
                        ms.scale(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case KAMUI_EYE: {
                        ms.pushPose();
                        ms.translate(0.4, 0.1, -0.2);
                        ms.scale(0.5f, -0.5f, -0.5f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        ms.popPose();
                        ms.translate(-0.4, 0.1, -0.2);
                        ms.mulPose(VecHelper.rotateY(180.0f));
                        ms.scale(0.5f, -0.5f, -0.5f);
                        RenderHelper.renderItemCustomColor(living, stack, -16777140, ms, buffers, light, OverlayTexture.NO_OVERLAY);
                        break;
                    }
                    case FOUR_LEAF_CLOVER: {
                        ms.translate(0.1, 0.1, -0.13);
                        ms.scale(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case BOTANIST_EMBLEM: {
                        ms.translate(0.0, 0.375, -0.13);
                        ms.scale(0.3f, -0.3f, -0.3f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                    case LUSITANIC_SHIELD: {
                        ms.translate(0.0, 0.35, 0.13);
                        ms.mulPose(VecHelper.rotateZ(8.0f));
                        ms.mulPose(VecHelper.rotateY(180.0f));
                        ms.scale(0.6f, -0.6f, -0.6f);
                        Renderer.renderItem(stack, ms, buffers, light);
                        break;
                    }
                }
            }
        }

        private static void renderItem(ItemStack stack, PoseStack ms, MultiBufferSource buffers, int light) {
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, light, OverlayTexture.NO_OVERLAY, ms, buffers, (Level)Minecraft.getInstance().level, 0);
        }
    }
}

