/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.lib.BotaniaTags;

public class LaputaShardItem
extends Item
implements LensEffectItem,
TinyPlanetExcempt,
CustomCreativeTabContents {
    private static final String TAG_STATE = "_state";
    private static final String TAG_TILE = "_tile";
    private static final String TAG_X = "_x";
    private static final String TAG_Y = "_y";
    private static final String TAG_Y_START = "_yStart";
    private static final String TAG_Z = "_z";
    private static final String TAG_POINTY = "_pointy";
    private static final String TAG_HEIGHTSCALE = "_heightscale";
    private static final String TAG_ITERATION_I = "iterationI";
    private static final String TAG_ITERATION_J = "iterationJ";
    private static final String TAG_ITERATION_K = "iterationK";
    public static final String TAG_LEVEL = "level";
    private static final int BASE_RANGE = 14;
    private static final int BASE_OFFSET = 42;

    public LaputaShardItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        for (int i = 0; i <= 20; i += 5) {
            ItemStack s = new ItemStack((ItemLike)this);
            if (i != 0) {
                s.getOrCreateTag().putInt(TAG_LEVEL, i - 1);
            }
            output.accept(s);
        }
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        int level = LaputaShardItem.getShardLevel(stack);
        MutableComponent levelLoc = Component.translatable((String)("botania.roman" + (level + 1)));
        list.add((Component)Component.translatable((String)"botaniamisc.shardLevel", (Object[])new Object[]{levelLoc}).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)"botaniamisc.shardRange", (Object[])new Object[]{this.getRange(stack)}).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (pos.getY() < world.getMaxBuildHeight() - 42 && !world.dimensionType().hasCeiling()) {
            if (!world.isClientSide) {
                world.gameEvent((Entity)ctx.getPlayer(), GameEvent.ENTITY_PLACE, pos);
                world.playSound(null, pos, BotaniaSounds.laputaStart, SoundSource.BLOCKS, 1.0f + world.random.nextFloat(), world.random.nextFloat() * 0.7f + 1.3f);
                ItemStack stack = ctx.getItemInHand();
                this.spawnFirstBurst(world, pos, stack);
                if (ctx.getPlayer() != null) {
                    UseItemSuccessTrigger.INSTANCE.trigger((ServerPlayer)ctx.getPlayer(), stack, (ServerLevel)world, pos.getX(), pos.getY(), pos.getZ());
                }
                stack.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    private int getRange(ItemStack shard) {
        return 14 + LaputaShardItem.getShardLevel(shard);
    }

    protected void spawnFirstBurst(Level world, BlockPos pos, ItemStack shard) {
        int range = this.getRange(shard);
        boolean pointy = world.random.nextDouble() < 0.25;
        double heightscale = (world.random.nextDouble() + 0.5) * (14.0 / (double)range);
        this.spawnNextBurst(world, pos, shard, pointy, heightscale);
    }

    protected void spawnNextBurst(Level world, BlockPos pos, ItemStack lens) {
        boolean pointy = ItemNBTHelper.getBoolean(lens, TAG_POINTY, false);
        double heightscale = ItemNBTHelper.getDouble(lens, TAG_HEIGHTSCALE, 1.0);
        this.spawnNextBurst(world, pos, lens, pointy, heightscale);
    }

    private static boolean canMove(BlockState state, Level world, BlockPos pos) {
        FluidState fluidState = state.getFluidState();
        boolean isFlowingFluid = !fluidState.isEmpty() && !fluidState.isSource();
        Block block = state.getBlock();
        return !state.isAir() && !isFlowingFluid && !(block instanceof FallingBlock) && (!state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) || state.is(BotaniaTags.Blocks.LAPUTA_NO_DOUBLE_BLOCK) || state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) && !state.is(BotaniaTags.Blocks.LAPUTA_IMMOBILE) && state.getDestroySpeed((BlockGetter)world, pos) != -1.0f;
    }

    private void spawnNextBurst(Level world, BlockPos pos, ItemStack shard, boolean pointy, double heightscale) {
        int range = this.getRange(shard);
        int i = ItemNBTHelper.getInt(shard, TAG_ITERATION_I, 0);
        int j = ItemNBTHelper.getInt(shard, TAG_ITERATION_J, 35);
        int k = ItemNBTHelper.getInt(shard, TAG_ITERATION_K, 0);
        if (j <= -28) {
            j = 35;
        }
        if (k >= range * 2 + 1) {
            k = 0;
        }
        while (i < range * 2 + 1) {
            while (j > -28) {
                while (k < range * 2 + 1) {
                    BlockPos pos_ = pos.offset(-range + i, -14 + j, -range + k);
                    if (this.inRange(pos_, pos, range, heightscale, pointy)) {
                        BlockState state = world.getBlockState(pos_);
                        Block block = state.getBlock();
                        if (LaputaShardItem.canMove(state, world, pos_)) {
                            BlockEntity tile = world.getBlockEntity(pos_);
                            CompoundTag cmp = new CompoundTag();
                            if (tile != null) {
                                cmp = tile.saveWithFullMetadata();
                                BlockEntity newTile = ((EntityBlock)block).newBlockEntity(pos_, state);
                                world.setBlockEntity(newTile);
                            }
                            if (!world.removeBlock(pos_, false)) {
                                if (tile != null) {
                                    world.setBlockEntity(tile);
                                }
                            } else {
                                world.levelEvent(2001, pos_, Block.getId((BlockState)state));
                                world.gameEvent(null, GameEvent.BLOCK_DESTROY, pos_);
                                ItemStack copyLens = new ItemStack((ItemLike)this);
                                copyLens.getOrCreateTag().putInt(TAG_LEVEL, LaputaShardItem.getShardLevel(shard));
                                copyLens.getTag().put(TAG_STATE, (Tag)NbtUtils.writeBlockState((BlockState)state));
                                ItemNBTHelper.setCompound(copyLens, TAG_TILE, cmp);
                                ItemNBTHelper.setInt(copyLens, TAG_X, pos.getX());
                                ItemNBTHelper.setInt(copyLens, TAG_Y, pos.getY());
                                ItemNBTHelper.setInt(copyLens, TAG_Y_START, pos_.getY());
                                ItemNBTHelper.setInt(copyLens, TAG_Z, pos.getZ());
                                ItemNBTHelper.setBoolean(copyLens, TAG_POINTY, pointy);
                                ItemNBTHelper.setDouble(copyLens, TAG_HEIGHTSCALE, heightscale);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_I, i);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_J, j);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_K, k);
                                ManaBurstEntity burst = this.getBurst(world, pos_, copyLens);
                                world.addFreshEntity((Entity)burst);
                                return;
                            }
                        }
                    }
                    ++k;
                }
                k = 0;
                --j;
            }
            j = 35;
            ++i;
        }
    }

    public static int getShardLevel(ItemStack shard) {
        if (!shard.hasTag()) {
            return 0;
        }
        return shard.getOrCreateTag().getInt(TAG_LEVEL);
    }

    private boolean inRange(BlockPos pos, BlockPos srcPos, int range, double heightscale, boolean pointy) {
        if (pos.getY() >= srcPos.getY()) {
            return MathHelper.pointDistanceSpace(pos.getX(), 0.0, pos.getZ(), srcPos.getX(), 0.0, srcPos.getZ()) < (float)range;
        }
        if (!pointy) {
            return MathHelper.pointDistanceSpace(pos.getX(), (double)pos.getY() / heightscale, pos.getZ(), srcPos.getX(), (double)srcPos.getY() / heightscale, srcPos.getZ()) < (float)range;
        }
        return (double)MathHelper.pointDistanceSpace(pos.getX(), 0.0, pos.getZ(), srcPos.getX(), 0.0, srcPos.getZ()) < (double)range - (double)(srcPos.getY() - pos.getY()) / heightscale;
    }

    public ManaBurstEntity getBurst(Level world, BlockPos pos, ItemStack stack) {
        ManaBurstEntity burst = (ManaBurstEntity)BotaniaEntities.MANA_BURST.create(world);
        burst.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        burst.setColor(60159);
        burst.setMana(1);
        burst.setStartingMana(1);
        burst.setMinManaLoss(0);
        burst.setManaLossPerTick(0.0f);
        burst.setGravity(0.0f);
        burst.setDeltaMovement(0.0, 0.5, 0.0);
        burst.setSourceLens(stack);
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        return false;
    }

    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        double speed = 0.35;
        int targetDistance = 42;
        ThrowableProjectile entity = burst.entity();
        if (!entity.level().isClientSide) {
            entity.setDeltaMovement(0.0, speed, 0.0);
            int spawnTicks = 2;
            int placeTicks = Mth.floor((double)((double)targetDistance / speed));
            ItemStack lens = burst.getSourceLens();
            if (burst.getTicksExisted() == 2) {
                int x = ItemNBTHelper.getInt(lens, TAG_X, 0);
                int y = ItemNBTHelper.getInt(lens, TAG_Y, Integer.MIN_VALUE);
                int z = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                if (y != Integer.MIN_VALUE) {
                    this.spawnNextBurst(entity.level(), new BlockPos(x, y, z), lens);
                }
            } else if (burst.getTicksExisted() == placeTicks) {
                int x = Mth.floor((double)entity.getX());
                int y = ItemNBTHelper.getInt(lens, TAG_Y_START, -1) + targetDistance;
                int z = Mth.floor((double)entity.getZ());
                BlockPos pos = new BlockPos(x, y, z);
                BlockState placeState = Blocks.AIR.defaultBlockState();
                if (lens.hasTag() && lens.getTag().contains(TAG_STATE)) {
                    placeState = NbtUtils.readBlockState((HolderGetter)entity.level().holderLookup(Registries.BLOCK), (CompoundTag)lens.getTag().getCompound(TAG_STATE));
                }
                if (entity.level().dimensionType().ultraWarm() && placeState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    placeState = (BlockState)placeState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                }
                if (entity.level().getBlockState(pos).canBeReplaced()) {
                    BlockEntity tile = null;
                    CompoundTag tilecmp = ItemNBTHelper.getCompound(lens, TAG_TILE, false);
                    if (tilecmp.contains("id")) {
                        tile = BlockEntity.loadStatic((BlockPos)pos, (BlockState)placeState, (CompoundTag)tilecmp);
                    }
                    if (placeState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && !placeState.is(BotaniaTags.Blocks.LAPUTA_NO_DOUBLE_BLOCK) && placeState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                        entity.level().setBlock(pos.above(), (BlockState)placeState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
                    }
                    entity.level().setBlockAndUpdate(pos, placeState);
                    entity.level().levelEvent(2001, pos, Block.getId((BlockState)placeState));
                    entity.level().gameEvent(null, GameEvent.BLOCK_PLACE, pos);
                    if (tile != null) {
                        entity.level().setBlockEntity(tile);
                    }
                } else {
                    int ox = ItemNBTHelper.getInt(lens, TAG_X, 0);
                    int oy = ItemNBTHelper.getInt(lens, TAG_Y_START, -1);
                    int oz = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                    Block.dropResources((BlockState)placeState, (Level)entity.level(), (BlockPos)new BlockPos(ox, oy, oz));
                }
                entity.discard();
            }
        }
    }

    @Override
    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        ItemStack lens = burst.getSourceLens();
        BlockState state = NbtUtils.readBlockState((HolderGetter)entity.level().holderLookup(Registries.BLOCK), (CompoundTag)lens.getOrCreateTag().getCompound(TAG_STATE));
        entity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), entity.getX(), entity.getY(), entity.getZ(), entity.getDeltaMovement().x(), entity.getDeltaMovement().y(), entity.getDeltaMovement().z());
        return true;
    }

    @Override
    public boolean shouldPull(ItemStack stack) {
        return false;
    }
}

