/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

public class ManaBarTooltipComponent
implements ClientTooltipComponent {
    private final float percentageFull;
    private final int pickLevel;
    private int mouseX;
    private int mouseY;
    private int totalWidth;

    public ManaBarTooltipComponent(ManaBarTooltip component) {
        this.percentageFull = component.getPercentageFull();
        this.pickLevel = component.getPickLevel();
    }

    @Nullable
    public static ClientTooltipComponent tryConvert(TooltipComponent component) {
        if (component instanceof ManaBarTooltip) {
            ManaBarTooltip t = (ManaBarTooltip)component;
            return new ManaBarTooltipComponent(t);
        }
        return null;
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth(Font font) {
        return 0;
    }

    public void setContext(int mouseX, int mouseY, int totalWidth) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.totalWidth = totalWidth;
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource buffers) {
        int level = this.pickLevel;
        if (level < 0) {
            return;
        }
        boolean ss = level >= TerraShattererItem.LEVELS.length - 1;
        String rank = I18n.get((String)("botania.rank" + this.pickLevel), (Object[])new Object[0]).replaceAll("&", "\u00a7");
        font.drawInBatch(rank, (float)this.mouseX, (float)(this.mouseY - 16), 0xFFFFFF, true, matrix, (MultiBufferSource)buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (!ss) {
            rank = I18n.get((String)("botania.rank" + (level + 1)), (Object[])new Object[0]).replaceAll("&", "\u00a7");
            font.drawInBatch(rank, (float)(this.mouseX + this.totalWidth - font.width(rank)), (float)(this.mouseY - 16), 0xFFFFFF, true, matrix, (MultiBufferSource)buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void renderImage(Font font, int x, int y, GuiGraphics gui) {
        PoseStack ps = gui.pose();
        int height = 3;
        int offsetFromBox = 4;
        ps.pushPose();
        if (this.pickLevel >= 0) {
            boolean ss = this.pickLevel >= TerraShattererItem.LEVELS.length - 1;
            int rainbowWidth = Math.min(this.totalWidth - (ss ? 0 : 1), (int)((float)this.totalWidth * this.percentageFull));
            float huePer = this.totalWidth == 0 ? 0.0f : 1.0f / (float)this.totalWidth;
            float hueOff = ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.01f;
            gui.fill(this.mouseX - 1, this.mouseY - height - offsetFromBox - 1, this.mouseX + this.totalWidth + 1, this.mouseY - offsetFromBox, -16777216);
            for (int i = 0; i < rainbowWidth; ++i) {
                gui.fill(this.mouseX + i, this.mouseY - height - offsetFromBox, this.mouseX + i + 1, this.mouseY - offsetFromBox, 0xFF000000 | Mth.hsvToRgb((float)((hueOff + huePer * (float)i) % 1.0f), (float)1.0f, (float)1.0f));
            }
            gui.fill(this.mouseX + rainbowWidth, this.mouseY - height - offsetFromBox, this.mouseX + this.totalWidth, this.mouseY - offsetFromBox, -11184811);
        } else {
            int manaBarWidth = (int)Math.ceil((float)this.totalWidth * this.percentageFull);
            gui.fill(this.mouseX - 1, this.mouseY - height - offsetFromBox - 1, this.mouseX + this.totalWidth + 1, this.mouseY - offsetFromBox, -16777216);
            gui.fill(this.mouseX, this.mouseY - height - offsetFromBox, this.mouseX + manaBarWidth, this.mouseY - offsetFromBox, 0xFF000000 | Mth.hsvToRgb((float)0.528f, (float)(((float)Math.sin((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.2) + 1.0f) * 0.3f + 0.4f), (float)1.0f));
            gui.fill(this.mouseX + manaBarWidth, this.mouseY - height - offsetFromBox, this.mouseX + this.totalWidth, this.mouseY - offsetFromBox, -11184811);
        }
        ps.popPose();
        this.mouseY = 0;
        this.mouseX = 0;
        this.totalWidth = 50;
    }
}

