/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class NbtOutputRecipe {
    public static final RecipeSerializer<Recipe<?>> SERIALIZER = new Serializer();

    private static class Serializer
    implements RecipeSerializer<Recipe<?>> {
        private Serializer() {
        }

        @NotNull
        public Recipe<?> fromJson(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            Recipe recipe = RecipeManager.fromJson((ResourceLocation)resourceLocation, (JsonObject)GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"recipe"));
            JsonElement nbt = jsonObject.get("nbt");
            if (nbt == null) {
                throw new JsonSyntaxException("No nbt tag");
            }
            try {
                CompoundTag tag = TagParser.parseTag((String)GsonHelper.convertToString((JsonElement)nbt, (String)"nbt"));
                recipe.getResultItem((RegistryAccess)RegistryAccess.EMPTY).setTag(tag);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid nbt tag: " + e.getMessage(), (Throwable)e);
            }
            return recipe;
        }

        @NotNull
        public Recipe<?> fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull Recipe<?> recipe) {
            throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
        }
    }
}

