package vazkii.botania.fabric.data;

import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.relic.DiceOfFateItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.data.ItemTagProvider;

import java.util.concurrent.CompletableFuture;

import static vazkii.botania.common.item.BotaniaItems.*;

public class FabricItemTagProvider extends ItemTagProvider {
	public static final class_6862<class_1792> QUARTZ_BLOCKS = itemTag(new class_2960("c", "quartz_blocks"));
	private static final class_6862<class_1792> MUSHROOMS = itemTag(new class_2960("c", "mushrooms"));
	private static final class_6862<class_1792> GLASS = itemTag(new class_2960("c", "glass"));
	private static final class_6862<class_1792> GLASS_ALT = itemTag(new class_2960("c", "glass_blocks"));
	private static final class_6862<class_1792> GLASS_PANE = itemTag(new class_2960("c", "glass_pane"));
	private static final class_6862<class_1792> GLASS_PANE_ALT = itemTag(new class_2960("c", "glass_panes"));
	public static final class_6862<class_1792> WOODEN_CHESTS = itemTag(new class_2960("c", "wooden_chests"));

	private static class_6862<class_1792> itemTag(class_2960 location) {
		return class_6862.method_40092(class_7924.field_41197, location);
	}

	public FabricItemTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookupProvider, CompletableFuture<class_2474.class_8211<class_2248>> blockTagProvider) {
		super(packOutput, lookupProvider, blockTagProvider);
	}

	@Override
	protected void method_10514(class_7225.class_7874 provider) {
		ColorHelper.supportedColors().forEach(color -> {
			this.method_46827(MUSHROOMS).method_46829(BotaniaBlocks.getMushroom(color).method_8389());
		});
		this.method_46218(FabricBlockTagProvider.MUSHROOMS, MUSHROOMS);
		this.method_46218(FabricBlockTagProvider.QUARTZ_BLOCKS, QUARTZ_BLOCKS);
		this.method_46218(FabricBlockTagProvider.GLASS, GLASS);
		this.method_46218(FabricBlockTagProvider.GLASS_ALT, GLASS_ALT);
		this.method_46218(FabricBlockTagProvider.GLASS_PANE, GLASS_PANE);
		this.method_46218(FabricBlockTagProvider.GLASS_PANE_ALT, GLASS_PANE_ALT);
		this.method_46827(WOODEN_CHESTS).method_46830(class_1802.field_8106, class_1802.field_8247);

		this.method_46827(BotaniaTags.Items.LENS_GLUE).method_46829(class_1802.field_8777).method_46829(class_1802.field_20417);

		generateToolTags();
		generateAccessoryTags();
		generateCompatTags();
	}

	private void generateToolTags() {
		this.method_46827(ConventionalItemTags.BOWS).method_46830(livingwoodBow, crystalBow);
		this.method_46827(ConventionalItemTags.SHEARS).method_46830(manasteelShears, elementiumShears);
	}

	private void generateAccessoryTags() {
		this.method_46827(accessory("chest/cape")).method_46830(
				balanceCloak,
				holyCloak,
				invisibilityCloak,
				unholyCloak
		);
		this.method_46827(accessory("chest/necklace")).method_46830(
				bloodPendant,
				cloudPendant,
				divaCharm,
				goddessCharm,
				icePendant,
				lavaPendant,
				superCloudPendant,
				superLavaPendant,
				thirdEye
		);
		class_1792[] rings = {
				auraRing,
				auraRingGreater,
				dodgeRing,
				lokiRing,
				magnetRing,
				magnetRingGreater,
				manaRing,
				manaRingGreater,
				miningRing,
				odinRing,
				pixieRing,
				reachRing,
				swapRing,
				thorRing,
				waterRing
		};
		this.method_46827(accessory("hand/ring")).method_46830(rings);
		this.method_46827(accessory("offhand/ring")).method_46830(rings);
		this.method_46827(accessory("head/face")).method_46830(
				itemFinder,
				monocle,
				tinyPlanet
		);
		this.method_46827(accessory("head/hat")).method_46829(
				flightTiara
		);
		this.method_46827(accessory("legs/belt")).method_46830(
				knockbackBelt,
				speedUpBelt,
				superTravelBelt,
				travelBelt
		);
		this.method_46827(accessory("all")).method_46830(
				blackBowtie, blackTie,
				redGlasses, puffyScarf,
				engineerGoggles, eyepatch,
				wickedEyepatch, redRibbons,
				pinkFlowerBud, polkaDottedBows,
				blueButterfly, catEars,
				witchPin, devilTail,
				kamuiEye, googlyEyes,
				fourLeafClover, clockEye,
				unicornHorn, devilHorns,
				hyperPlus, botanistEmblem,
				ancientMask, eerieMask,
				alienAntenna, anaglyphGlasses,
				orangeShades, grouchoGlasses,
				thickEyebrows, lusitanicShield,
				tinyPotatoMask, questgiverMark,
				thinkingHand
		);
	}

	private void generateCompatTags() {
		this.method_46827(itemTag(new class_2960("modern_industrialization", "replicator_blacklist")))
				.method_46830(DiceOfFateItem.RELIC_STACKS.get().stream().map(class_1799::method_7909).toArray(class_1792[]::new))
				.method_46830(dice, manaTablet, manaRing, manaRingGreater, blackerLotus, blackHoleTalisman, flowerBag,
						spawnerMover, terraPick, BotaniaBlocks.terrasteelBlock.method_8389());
	}

	private static class_6862<class_1792> accessory(String name) {
		return itemTag(new class_2960("trinkets", name));
	}
}
