/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.item.WireframeCoordinateListProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.CollectingNeighborUpdaterAccess;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.mixin.LevelAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4262;
import net.minecraft.class_5250;
import net.minecraft.class_7165;
import net.minecraft.class_7923;

public class ShiftingCrustRodItem extends class_1792 implements WireframeCoordinateListProvider {

	private static final int RANGE = 3;
	private static final int COST = 40;

	private static final String TAG_REPLACEMENT_ITEM = "placedItem";
	private static final String TAG_TARGET_BLOCK_NAME = "targetBlock";
	private static final String TAG_SWAPPING = "swapping";
	private static final String TAG_SELECT_X = "selectX";
	private static final String TAG_SELECT_Y = "selectY";
	private static final String TAG_SELECT_Z = "selectZ";
	private static final String TAG_EXTRA_RANGE = "extraRange";
	private static final String TAG_SWAP_HIT_VEC = "swapHitVec";
	private static final String TAG_SWAP_DIRECTION = "swapDirection";
	private static final String TAG_SWAP_CLICKED_AXIS = "swapClickAxis";
	private static final String TAG_TEMPERANCE_STONE = "temperanceStone";

	public ShiftingCrustRodItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_1657 player = ctx.method_8036();
		class_1799 stack = ctx.method_8041();
		class_2680 wstate = world.method_8320(pos);
		class_2248 block = wstate.method_26204();

		if (player != null && player.method_21823()) {
			class_2586 tile = world.method_8321(pos);
			if (tile == null && block.method_8389() != class_1802.field_8162
					&& (wstate.method_26216(world, pos) || wstate.method_26217() == class_2464.field_11458)
					&& (wstate.method_26225() || block instanceof class_4262 || block instanceof class_2389)
					&& block.method_8389() instanceof class_1747) {
				setItemToPlace(stack, block.method_8389());
				setSwapTemplateDirection(stack, ctx.method_8038());
				setHitPos(stack, ctx.method_17698());

				displayRemainderCounter(player, stack);
				return class_1269.method_29236(world.method_8608());
			}
		} else if (canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
			class_1792 replacement = getItemToPlace(stack);
			List<class_2338> swap = getTargetPositions(world, stack, replacement, pos, block, ctx.method_8038());
			if (swap.size() > 0) {
				ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
				ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.method_10263());
				ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.method_10264());
				ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.method_10260());
				setSwapClickDirection(stack, ctx.method_8038());
				setTarget(stack, block);
			}
		}

		return class_1269.method_29236(world.method_8608());
	}

	@Override
	public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
		return !player.method_7337();
	}

	public class_1269 onLeftClick(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 side) {
		if (player.method_7325()) {
			return class_1269.field_5811;
		}

		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960() && stack.method_31574(this)) {
			// Skip logic on the client, the server will replace the block when it receives the action packet
			if (world.method_8608()) {
				return class_1269.field_5812;
			}

			if (canExchange(stack) && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
				int exchange = exchange(world, player, pos, stack, getItemToPlace(stack));
				if (exchange > 0) {
					ManaItemHandler.instance().requestManaExactForTool(stack, player, exchange, true);
				}
			}
			// Always return SUCCESS with rod in hand to prevent any vanilla block breaking
			return class_1269.field_5812;
		}
		return class_1269.field_5811;

	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean equipped) {
		if (!canExchange(stack) || !(entity instanceof class_1657 player)) {
			return;
		}

		int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
		int extraRangeNew = ManaItemHandler.instance().hasProficiency(player, stack) ? 3 : 1;
		if (extraRange != extraRangeNew) {
			ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
		}
		boolean temperanceActive = StoneOfTemperanceItem.hasTemperanceActive(player);
		if (temperanceActive != stack.method_7948().method_10577(TAG_TEMPERANCE_STONE)) {
			stack.method_7948().method_10556(TAG_TEMPERANCE_STONE, temperanceActive);
		}

		class_1792 replacement = getItemToPlace(stack);
		if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
			if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
				endSwapping(stack);
				return;
			}

			int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
			int y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0);
			int z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0);
			class_2248 target = getTargetState(stack);
			List<class_2338> swap = getTargetPositions(world, stack, replacement, new class_2338(x, y, z), target, getSwapClickDirection(stack));
			if (swap.size() == 0) {
				endSwapping(stack);
				return;
			}

			class_2338 coords = swap.get(world.field_9229.method_43048(swap.size()));
			int exchange = exchange(world, player, coords, stack, replacement);
			if (exchange > 0) {
				ManaItemHandler.instance().requestManaForTool(stack, player, exchange, true);
			} else {
				endSwapping(stack);
			}
		}
	}

	public List<class_2338> getTargetPositions(class_1937 world, class_1799 stack, class_1792 toPlace, class_2338 pos, class_2248 toReplace, class_2350 clickedSide) {
		// Our result list
		List<class_2338> coordsList = new ArrayList<>();

		// We subtract 1 from the effective range as the center tile is included
		// So, with a range of 3, we are visiting tiles at -2, -1, 0, 1, 2
		// If we have the stone of temperance, on one axis we only visit 0.
		class_2350.class_2351 axis = clickedSide.method_10166();
		int xRange = getRange(stack, axis, class_2350.class_2351.field_11048);
		int yRange = getRange(stack, axis, class_2350.class_2351.field_11052);
		int zRange = getRange(stack, axis, class_2350.class_2351.field_11051);

		// Iterate in all 3 dimensions through our possible positions.
		for (int offsetX = -xRange; offsetX <= xRange; offsetX++) {
			for (int offsetY = -yRange; offsetY <= yRange; offsetY++) {
				for (int offsetZ = -zRange; offsetZ <= zRange; offsetZ++) {
					class_2338 pos_ = pos.method_10069(offsetX, offsetY, offsetZ);

					class_2680 currentState = world.method_8320(pos_);

					// If this block is not our target, ignore it, as we don't need
					// to consider replacing it
					if (!currentState.method_27852(toReplace)) {
						continue;
					}

					// If this block is already the block we're swapping to,
					// we don't need to swap again
					if (currentState.method_26204().method_8389() == toPlace) {
						continue;
					}

					// Check to see if the block is visible on any side:
					for (class_2350 dir : class_2350.values()) {
						class_2338 adjPos = pos_.method_10093(dir);
						class_2680 adjState = world.method_8320(adjPos);

						if (!class_2248.method_9501(adjState.method_26222(world, pos), dir.method_10153())) {
							coordsList.add(pos_);
							break;
						}
					}
				}
			}
		}

		return coordsList;
	}

	public int exchange(class_1937 world, class_1657 player, class_2338 pos, class_1799 rod, class_1792 replacement) {
		class_2586 tile = world.method_8321(pos);
		if (tile != null) {
			return 0;
		}

		class_1799 placeStack = removeFromInventory(player, rod, replacement, false);
		if (!placeStack.method_7960()) {
			class_2680 stateAt = world.method_8320(pos);
			if (!stateAt.method_26215() && stateAt.method_26165(player, world, pos) > 0
					&& stateAt.method_26204().method_8389() != replacement) {
				float hardness = stateAt.method_26214(world, pos);
				if (!world.field_9236) {
					final class_7165 neighborUpdater = ((LevelAccessor) world).getNeighborUpdater();
					try {
						if (neighborUpdater instanceof CollectingNeighborUpdaterAccess access) {
							access.botania$pauseUpdates();
						}
						world.method_8651(pos, !player.method_31549().field_7477, player);
						class_3965 hit = new class_3965(getHitPos(rod, pos), getSwapTemplateDirection(rod), pos, false);
						class_1269 result = PlayerHelper.substituteUse(new class_1838(player, class_1268.field_5808, hit), placeStack);
						// TODO: provide an use context that overrides player facing direction/yaw?
						//  currently it pulls from the player directly

						if (!player.method_31549().field_7477) {
							if (result.method_23665()) {
								removeFromInventory(player, rod, replacement, true);
								displayRemainderCounter(player, rod);
							} else {
								((class_3218) world).method_14199(class_2398.field_11237, pos.method_10263() + 0.5D, pos.method_10264() + 0.5D, pos.method_10260() + 0.5D,
										2, 0.1, 0.1, 0.1, 0);
							}
						}
					} finally {
						if (neighborUpdater instanceof CollectingNeighborUpdaterAccess access) {
							access.botania$resumeUpdates();
						}
					}
				}
				return hardness <= 10 ? COST : (int) (0.5 * COST + 3 * hardness);
			}
		}

		return 0;
	}

	public boolean canExchange(class_1799 stack) {
		return getItemToPlace(stack) != class_1802.field_8162;
	}

	public static class_1799 removeFromInventory(class_1657 player, class_1263 inv, class_1799 tool, class_1792 requested, boolean doit) {
		List<BlockProvider> providers = new ArrayList<>();
		for (int i = inv.method_5439() - 1; i >= 0; i--) {
			class_1799 invStack = inv.method_5438(i);
			if (invStack.method_7960()) {
				continue;
			}

			class_1792 item = invStack.method_7909();
			if (item == requested) {
				class_1799 ret;
				if (doit) {
					ret = inv.method_5434(i, 1);
				} else {
					ret = invStack.method_46651(1);
				}
				return ret;
			}

			var provider = XplatAbstractions.INSTANCE.findBlockProvider(invStack);
			if (provider != null) {
				providers.add(provider);
			}
		}

		if (requested instanceof class_1747 blockItem) {
			class_2248 block = blockItem.method_7711();
			for (BlockProvider prov : providers) {
				if (prov.provideBlock(player, tool, block, doit)) {
					return new class_1799(requested);
				}
			}
		}

		return class_1799.field_8037;
	}

	public static class_1799 removeFromInventory(class_1657 player, class_1799 tool, class_1792 item, boolean doit) {
		if (player.method_31549().field_7477) {
			return new class_1799(item);
		}

		class_1799 outStack = removeFromInventory(player, BotaniaAPI.instance().getAccessoriesInventory(player), tool, item, doit);
		if (outStack.method_7960()) {
			outStack = removeFromInventory(player, player.method_31548(), tool, item, doit);
		}
		return outStack;
	}

	public static int getInventoryItemCount(class_1657 player, class_1799 stack, class_1792 item) {
		if (player.method_31549().field_7477) {
			return -1;
		}

		int baubleCount = getInventoryItemCount(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, item);
		if (baubleCount == -1) {
			return -1;
		}

		int count = getInventoryItemCount(player, player.method_31548(), stack, item);
		if (count == -1) {
			return -1;
		}

		return count + baubleCount;
	}

	public static int getInventoryItemCount(class_1657 player, class_1263 inv, class_1799 stack, class_1792 requested) {
		if (player.method_31549().field_7477) {
			return -1;
		}

		int count = 0;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 invStack = inv.method_5438(i);
			if (invStack.method_7960()) {
				continue;
			}

			class_1792 item = invStack.method_7909();
			if (item == requested.method_8389()) {
				count += invStack.method_7947();
			}

			var prov = XplatAbstractions.INSTANCE.findBlockProvider(invStack);
			if (prov != null && requested instanceof class_1747 blockItem) {
				int provCount = prov.getBlockCount(player, stack, blockItem.method_7711());
				if (provCount == -1) {
					return -1;
				}
				count += provCount;
			}
		}

		return count;
	}

	public void displayRemainderCounter(class_1657 player, class_1799 stack) {
		if (!player.method_37908().field_9236) {
			class_1792 item = getItemToPlace(stack);
			int count = getInventoryItemCount(player, stack, item);
			ItemsRemainingRenderHandler.send(player, new class_1799(item), count);
		}
	}

	private void setItemToPlace(class_1799 stack, class_1792 item) {
		ItemNBTHelper.setString(stack, TAG_REPLACEMENT_ITEM, class_7923.field_41178.method_10221(item).toString());
	}

	private class_1792 getItemToPlace(class_1799 stack) {
		return class_7923.field_41178.method_10223(class_2960.method_12829(ItemNBTHelper.getString(stack, TAG_REPLACEMENT_ITEM, "air")));
	}

	private void setHitPos(class_1799 stack, class_243 vec) {
		class_2499 list = new class_2499();
		list.add(class_2489.method_23241(class_3532.method_15385(vec.method_10216())));
		list.add(class_2489.method_23241(class_3532.method_15385(vec.method_10214())));
		list.add(class_2489.method_23241(class_3532.method_15385(vec.method_10215())));
		stack.method_7948().method_10566(TAG_SWAP_HIT_VEC, list);
	}

	private class_243 getHitPos(class_1799 stack, class_2338 pos) {
		class_2499 list = stack.method_7948().method_10554(TAG_SWAP_HIT_VEC, class_2520.field_33256);
		return new class_243(pos.method_10263() + list.method_10611(0),
				pos.method_10264() + list.method_10611(1),
				pos.method_10260() + list.method_10611(2));
	}

	private void setSwapTemplateDirection(class_1799 stack, class_2350 direction) {
		stack.method_7948().method_10569(TAG_SWAP_DIRECTION, direction.method_10146());
	}

	private class_2350 getSwapTemplateDirection(class_1799 stack) {
		return class_2350.method_10143(stack.method_7948().method_10550(TAG_SWAP_DIRECTION));
	}

	private void setSwapClickDirection(class_1799 stack, class_2350 direction) {
		stack.method_7948().method_10569(TAG_SWAP_CLICKED_AXIS, direction.method_10146());
	}

	private class_2350 getSwapClickDirection(class_1799 stack) {
		return class_2350.method_10143(stack.method_7948().method_10550(TAG_SWAP_CLICKED_AXIS));
	}

	private int getRange(class_1799 stack, class_2350.class_2351 clickAxis, class_2350.class_2351 rangeAxis) {
		if (stack.method_7948().method_10577(TAG_TEMPERANCE_STONE) && rangeAxis == clickAxis) {
			return 0;
		}
		return RANGE + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;
	}

	private static void endSwapping(class_1799 stack) {
		ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
		ItemNBTHelper.removeEntry(stack, TAG_SELECT_X);
		ItemNBTHelper.removeEntry(stack, TAG_SELECT_Y);
		ItemNBTHelper.removeEntry(stack, TAG_SELECT_Z);
		ItemNBTHelper.removeEntry(stack, TAG_TARGET_BLOCK_NAME);
		ItemNBTHelper.removeEntry(stack, TAG_SWAP_CLICKED_AXIS);
	}

	@NotNull
	@Override
	public class_2561 method_7864(@NotNull class_1799 stack) {
		class_1792 item = getItemToPlace(stack);
		class_5250 cmp = super.method_7864(stack).method_27661();
		if (item != class_1802.field_8162) {
			cmp.method_27693(" (");
			class_2561 sub = new class_1799(item).method_7964();
			cmp.method_10852(sub.method_27661().method_27692(class_124.field_1060));
			cmp.method_27693(")");
		}
		return cmp;
	}

	private void setTarget(class_1799 stack, class_2248 block) {
		ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, class_7923.field_41175.method_10221(block).toString());
	}

	public static class_2248 getTargetState(class_1799 stack) {
		class_2960 id = new class_2960(ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "minecraft:air"));
		return class_7923.field_41175.method_10223(id);
	}

	@Override
	public List<class_2338> getWireframesToDraw(class_1657 player, class_1799 stack) {
		class_1799 holding = player.method_6047();
		if (holding != stack || !canExchange(stack)) {
			return ImmutableList.of();
		}

		class_239 pos = class_310.method_1551().field_1765;
		if (pos != null && pos.method_17783() == class_239.class_240.field_1332) {
			class_2338 bPos = ((class_3965) pos).method_17777();
			class_2248 target = class_310.method_1551().field_1687.method_8320(bPos).method_26204();
			if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
				bPos = new class_2338(
						ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0),
						ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0),
						ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0)
				);
				target = getTargetState(stack);
			}

			if (!player.method_37908().method_22347(bPos)) {
				class_1792 item = getItemToPlace(stack);
				List<class_2338> coordsList = getTargetPositions(player.method_37908(), stack, item, bPos, target, ((class_3965) pos).method_17780());
				coordsList.removeIf(bPos::equals);
				return coordsList;
			}

		}
		return ImmutableList.of();
	}

}
