/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.clientbound;

import vazkii.botania.common.item.rod.SkiesRodItem;
import vazkii.botania.network.BotaniaPacket;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public record AvatarSkiesRodPacket(boolean elytra) implements BotaniaPacket {
	public static final class_2960 ID = prefix("atr");

	@Override
	public void encode(class_2540 buf) {
		buf.writeBoolean(elytra);
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static AvatarSkiesRodPacket decode(class_2540 buf) {
		return new AvatarSkiesRodPacket(buf.readBoolean());
	}

	public static class Handler {
		public static void handle(AvatarSkiesRodPacket packet) {
			boolean elytra = packet.elytra();
			// Lambda trips verifier on forge
			class_310.method_1551().execute(
					new Runnable() {
						@Override
						public void run() {
							var player = class_310.method_1551().field_1724;
							var world = class_310.method_1551().field_1687;
							if (elytra) {
								SkiesRodItem.doAvatarElytraBoost(player, world);
							} else {
								SkiesRodItem.doAvatarJump(player, world);
							}
						}
					}

			);
		}
	}
}
