/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.proxy;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import vazkii.botania.client.core.handler.*;
import vazkii.botania.client.fx.BoltParticleOptions;
import vazkii.botania.client.fx.BoltRenderer;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.item.*;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import ;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4184;

public class ClientProxy implements Proxy {

	public static boolean jingleTheBells = false;
	public static boolean dootDoot = false;

	public static class_304 CORPOREA_REQUEST;

	public static void initKeybindings(Consumer<class_304> consumer) {
		CORPOREA_REQUEST = new class_304("key.botania_corporea_request", GLFW.GLFW_KEY_C, LibMisc.MOD_NAME);
		consumer.accept(CORPOREA_REQUEST);
	}

	public static void initSeasonal() {
		if (BotaniaConfig.client().enableSeasonalFeatures()) {
			LocalDateTime now = LocalDateTime.now();
			if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 2) {
				ClientProxy.jingleTheBells = true;
			}
			if (now.getMonth() == Month.OCTOBER) {
				ClientProxy.dootDoot = true;
			}
		}
	}

	@Override
	public void runOnClient(Supplier<Runnable> s) {
		s.get().run();
	}

	@Override
	public class_1657 getClientPlayer() {
		return class_310.method_1551().field_1724;
	}

	@Override
	public void lightningFX(class_1937 level, class_243 vectorStart, class_243 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
		// todo wip, params are ignored
		BoltRenderer.INSTANCE.add(level, new BoltParticleOptions(vectorStart, vectorEnd).size(0.08F), ClientTickHandler.partialTicks);
	}

	@Override
	public void addBoss(GaiaGuardianEntity boss) {
		BossBarHandler.bosses.add(boss);
	}

	@Override
	public void removeBoss(GaiaGuardianEntity boss) {
		BossBarHandler.bosses.remove(boss);
	}

	@Override
	public int getClientRenderDistance() {
		return class_310.method_1551().field_1690.method_42503().method_41753();
	}

	@Override
	public void addParticleForceNear(class_1937 world, class_2394 particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
		class_4184 info = class_310.method_1551().field_1773.method_19418();
		if (info.method_19332() && info.method_19326().method_1028(x, y, z) <= 1024.0D) {
			world.method_8466(particleData, true, x, y, z, xSpeed, ySpeed, zSpeed);
		}
	}

	@Override
	public void showMultiblock(IMultiblock mb, class_2561 name, class_2338 anchor, class_2470 rot) {
		PatchouliAPI.get().showMultiblock(mb, name, anchor, rot);
	}

	@Override
	public void clearSextantMultiblock() {
		IMultiblock mb = PatchouliAPI.get().getCurrentMultiblock();
		if (mb != null && mb.getID().equals(WorldshaperssSextantItem.MULTIBLOCK_ID)) {
			PatchouliAPI.get().clearMultiblock();
		}
	}

	@Nullable
	@Override
	public class_239 getClientHit() {
		return class_310.method_1551().field_1765;
	}

	@NotNull
	@Override
	public Locale getLocale() {
		final String languageCode = class_310.method_1551().method_1526().method_4669();
		final var parts = languageCode.split("_", 3);
		return parts.length > 2
				? new Locale(parts[0], parts[1], parts[2])
				: parts.length == 2 ? new Locale(parts[0], parts[1]) : new Locale(languageCode);
	}
}
