/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.*;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

/**
 * Copy of {@link net.minecraft.class_4942} with support for generating item predicate overrides.
 */
public class ModelWithOverrides {
	private final class_2960 parent;
	private final class_4945[] requiredTextures;

	public ModelWithOverrides(class_2960 parent, class_4945... requiredTextures) {
		this.parent = parent;
		this.requiredTextures = requiredTextures;
	}

	public void create(class_2960 modelId, class_4944 textures, OverrideHolder overrides, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		Map<class_4945, class_2960> textureMap = Streams.concat(Arrays.stream(this.requiredTextures), textures.method_25861())
				.collect(ImmutableMap.toImmutableMap(Function.identity(), textures::method_25867));
		consumer.accept(modelId, () -> {
			JsonObject ret = new JsonObject();
			ret.addProperty("parent", parent.toString());
			if (!textureMap.isEmpty()) {
				JsonObject textureJson = new JsonObject();
				textureMap.forEach((k, path) -> textureJson.addProperty(k.method_25912(), path.toString()));
				ret.add("textures", textureJson);
			}
			JsonArray overridesJson = overrides.toJson();
			if (overridesJson != null) {
				ret.add("overrides", overridesJson);
			}
			return ret;
		});
	}

}
