/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.block;

import org.jetbrains.annotations.NotNull;

import java.util.Locale;
import net.minecraft.class_2586;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

/**
 * Base Interface for the Petal Apothecary block entity
 */
public interface PetalApothecary {
	enum State implements class_3542 {
		EMPTY,
		WATER,
		LAVA;

		@NotNull
		@Override
		public String method_15434() {
			return name().toLowerCase(Locale.ROOT);
		}

		public class_3611 asVanilla() {
			return switch (this) {
				case EMPTY -> class_3612.field_15906;
				case WATER -> class_3612.field_15910;
				case LAVA -> class_3612.field_15908;
			};
		}
	}

	/**
	 * Set the contained fluid.
	 */
	void setFluid(State fluid);

	/**
	 * Get the contained fluid.
	 */
	State getFluid();

	default class_2586 blockEntity() {
		return (class_2586) this;
	}
}
