/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.FlameRingEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class HellsRodItem extends class_1792 {

	private static final class_2960 avatarOverlay = new class_2960(ResourcesLib.MODEL_AVATAR_FIRE);

	private static final int COST = 900;
	private static final int COOLDOWN = 1200;

	public HellsRodItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_1657 player = ctx.method_8036();
		class_1799 stack = ctx.method_8041();
		class_2338 pos = ctx.method_8037();

		if (player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, false)) {
			if (!world.method_8608()) {
				FlameRingEntity entity = BotaniaEntities.FLAME_RING.method_5883(world);
				entity.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5);
				world.method_8649(entity);

				if (!player.method_7337()) {
					player.method_7357().method_7906(this, ManaItemHandler.instance().hasProficiency(player, stack) ? COOLDOWN / 2 : COOLDOWN);
				}
				ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true);

				world.method_33596(player, class_5712.field_28161, pos);
				ctx.method_8045().method_43128(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), BotaniaSounds.fireRod, class_3419.field_15248, 1F, 1F);
			}
		}

		return class_1269.method_29236(world.method_8608());
	}

	public static class AvatarBehavior implements AvatarWieldable {
		@Override
		public void onAvatarUpdate(Avatar tile) {
			class_2586 te = (class_2586) tile;
			class_1937 world = te.method_10997();
			class_2338 pos = te.method_11016();
			ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, pos, te.method_11010(), te, null);

			if (!world.field_9236 && receiver.getCurrentMana() >= COST && tile.getElapsedFunctionalTicks() % 300 == 0 && tile.isEnabled()) {
				FlameRingEntity entity = BotaniaEntities.FLAME_RING.method_5883(world);
				entity.method_5814(pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5);
				world.method_8649(entity);
				receiver.receiveMana(-COST);
				world.method_33596(null, class_5712.field_28161, pos);
			}
		}

		@Override
		public class_2960 getOverlayResource(Avatar tile) {
			return avatarOverlay;
		}
	}

}
