/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.BotaniaDamageTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.KeyOfTheKingsLawItem;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public class BabylonWeaponEntity extends ThrowableCopyEntity {
	private static final String TAG_CHARGING = "charging";
	private static final String TAG_VARIETY = "variety";
	private static final String TAG_CHARGE_TICKS = "chargeTicks";
	private static final String TAG_LIVE_TICKS = "liveTicks";
	private static final String TAG_DELAY = "delay";
	private static final String TAG_ROTATION = "rotation";

	private static final class_2940<Boolean> CHARGING = class_2945.method_12791(BabylonWeaponEntity.class, class_2943.field_13323);
	private static final class_2940<Integer> VARIETY = class_2945.method_12791(BabylonWeaponEntity.class, class_2943.field_13327);
	private static final class_2940<Integer> CHARGE_TICKS = class_2945.method_12791(BabylonWeaponEntity.class, class_2943.field_13327);
	private static final class_2940<Integer> LIVE_TICKS = class_2945.method_12791(BabylonWeaponEntity.class, class_2943.field_13327);
	private static final class_2940<Integer> DELAY = class_2945.method_12791(BabylonWeaponEntity.class, class_2943.field_13327);
	private static final class_2940<Float> ROTATION = class_2945.method_12791(BabylonWeaponEntity.class, class_2943.field_13320);

	public BabylonWeaponEntity(class_1299<BabylonWeaponEntity> type, class_1937 world) {
		super(type, world);
	}

	public BabylonWeaponEntity(class_1309 thrower, class_1937 world) {
		super(BotaniaEntities.BABYLON_WEAPON, thrower, world);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(CHARGING, false);
		field_6011.method_12784(VARIETY, 0);
		field_6011.method_12784(CHARGE_TICKS, 0);
		field_6011.method_12784(LIVE_TICKS, 0);
		field_6011.method_12784(DELAY, 0);
		field_6011.method_12784(ROTATION, 0F);
	}

	@Override
	public boolean method_5640(double dist) {
		return dist < 64 * 64;
	}

	@Override
	public boolean method_5659() {
		return true;
	}

	@Override
	public void method_5773() {
		class_1297 thrower = method_24921();
		if (!(thrower instanceof class_1657 player) || !thrower.method_5805()) {
			if (!method_37908().field_9236) {
				method_31472();
			}
			return;
		}
		if (!method_37908().field_9236) {
			class_1799 stack = PlayerHelper.getFirstHeldItem(player, BotaniaItems.kingKey);
			boolean newCharging = !stack.method_7960() && KeyOfTheKingsLawItem.isCharging(stack);
			if (isCharging() != newCharging) {
				setCharging(newCharging);
			}
		}

		class_243 mot = method_18798();

		int liveTime = getLiveTicks();
		int delay = getDelay();
		boolean charging = isCharging() && liveTime == 0;

		if (charging) {
			method_18799(class_243.field_1353);

			int chargeTime = getChargeTicks();
			setChargeTicks(chargeTime + 1);

			if (method_37908().field_9229.method_43048(20) == 0) {
				method_37908().method_43128(null, method_23317(), method_23318(), method_23321(), BotaniaSounds.babylonSpawn, class_3419.field_15248, 0.1F, 1F + method_37908().field_9229.method_43057() * 3F);
			}
		} else {
			if (liveTime < delay) {
				method_18799(class_243.field_1353);
			} else if (liveTime == delay) {
				class_243 playerLook;
				class_3965 rtr = ToolCommons.raytraceFromEntity(player, 64, true);
				if (rtr.method_17783() != class_239.class_240.field_1332) {
					playerLook = player.method_5720().method_1021(64).method_1019(player.method_19538());
				} else {
					playerLook = class_243.method_24953(rtr.method_17777());
				}

				class_243 thisVec = VecHelper.fromEntityCenter(this);

				mot = playerLook.method_1023(thisVec.field_1352, thisVec.field_1351, thisVec.field_1350).method_1029().method_1021(2);
				method_37908().method_43128(null, method_23317(), method_23318(), method_23321(), BotaniaSounds.babylonAttack, class_3419.field_15248, 2F, 0.1F + method_37908().field_9229.method_43057() * 3F);
			}

			if (!method_37908().field_9236) {
				setLiveTicks(liveTime + 1);
				class_238 axis = new class_238(method_23317(), method_23318(), method_23321(), field_6038, field_5971, field_5989).method_1014(2);
				List<class_1309> entities = method_37908().method_18467(class_1309.class, axis);
				for (class_1309 living : entities) {
					if (living == thrower) {
						continue;
					}

					if (living.field_6235 == 0) {
						living.method_5643(method_37908().method_48963().method_48802(player), 20);
						method_7488(new class_3966(living));
						return;
					}
				}
			}
		}

		super.method_5773();

		// Apply after super tick so drag is not applied by super
		method_18799(mot);

		if (method_37908().field_9236 && liveTime > delay) {
			WispParticleData data = WispParticleData.wisp(0.3F, 1F, 1F, 0F, 1);
			method_37908().method_8406(data, method_23317(), method_23318(), method_23321(), 0, -0F, 0);
		}

		if (!method_37908().field_9236 && liveTime > 200 + delay) {
			method_31472();
		}
	}

	@Override
	protected void method_24920(@NotNull class_3965 hit) {
		super.method_24920(hit);
		explodeAndDie();
	}

	@Override
	protected void method_7454(@NotNull class_3966 hit) {
		super.method_7454(hit);
		if (hit.method_17782() != method_24921()) {
			explodeAndDie();
		}
	}

	private void explodeAndDie() {
		if (!method_37908().field_9236) {
			class_6880<class_8110> type = method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(BotaniaDamageTypes.KEY_EXPLOSION);
			class_1282 source = new class_1282(type, this, this.method_24921());
			method_37908().method_8454(this, source, null, method_23317(), method_23318(), method_23321(), 3F, false, class_1937.class_7867.field_40888);
			method_31472();
		}
	}

	@Override
	public void method_5652(@NotNull class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10556(TAG_CHARGING, isCharging());
		cmp.method_10569(TAG_VARIETY, getVariety());
		cmp.method_10569(TAG_CHARGE_TICKS, getChargeTicks());
		cmp.method_10569(TAG_LIVE_TICKS, getLiveTicks());
		cmp.method_10569(TAG_DELAY, getDelay());
		cmp.method_10548(TAG_ROTATION, getRotation());
	}

	@Override
	public void method_5749(@NotNull class_2487 cmp) {
		super.method_5749(cmp);
		setCharging(cmp.method_10577(TAG_CHARGING));
		setVariety(cmp.method_10550(TAG_VARIETY));
		setChargeTicks(cmp.method_10550(TAG_CHARGE_TICKS));
		setLiveTicks(cmp.method_10550(TAG_LIVE_TICKS));
		setDelay(cmp.method_10550(TAG_DELAY));
		setRotation(cmp.method_10583(TAG_ROTATION));
	}

	public boolean isCharging() {
		return field_6011.method_12789(CHARGING);
	}

	public void setCharging(boolean charging) {
		field_6011.method_12778(CHARGING, charging);
	}

	public int getVariety() {
		return field_6011.method_12789(VARIETY);
	}

	public void setVariety(int var) {
		field_6011.method_12778(VARIETY, var);
	}

	public int getChargeTicks() {
		return field_6011.method_12789(CHARGE_TICKS);
	}

	public void setChargeTicks(int ticks) {
		field_6011.method_12778(CHARGE_TICKS, ticks);
	}

	public int getLiveTicks() {
		return field_6011.method_12789(LIVE_TICKS);
	}

	public void setLiveTicks(int ticks) {
		field_6011.method_12778(LIVE_TICKS, ticks);
	}

	public int getDelay() {
		return field_6011.method_12789(DELAY);
	}

	public void setDelay(int delay) {
		field_6011.method_12778(DELAY, delay);
	}

	public float getRotation() {
		return field_6011.method_12789(ROTATION);
	}

	public void setRotation(float rot) {
		field_6011.method_12778(ROTATION, rot);
	}

}
