package vazkii.botania.test.block;

import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.item.BotaniaItems;

public class ApothecaryRecipeTest {

	private static final String TEMPLATE = "botania:block/apothecary_recipe";

	private static final class_2338 APOTHECARY = new class_2338(1, 2, 1);

	private void fillApothecary(class_4516 helper) {
		class_2680 apothecary = helper.method_35980(APOTHECARY);
		helper.method_35986(APOTHECARY, apothecary.method_11657(PetalApothecaryBlock.FLUID, PetalApothecary.State.WATER));
	}

	private void spawnItem(class_4516 helper, class_1792 item) {
		class_2338 pos = APOTHECARY.method_10084();
		helper.method_35968(item, pos.method_10263() + 0.5F, pos.method_10264() + 0.5F, pos.method_10260() + 0.5F);
	}

	@class_6302(method_35936 = TEMPLATE, method_35933 = "apothecary")
	public void testItemEnterPrevention(class_4516 helper) {
		helper.method_36041().method_36085(() -> {
			spawnItem(helper, BotaniaItems.whitePetal);
			spawnItem(helper, BotaniaItems.whitePetal);
			spawnItem(helper, BotaniaItems.whitePetal);
			spawnItem(helper, BotaniaItems.whitePetal);
		}).method_36077(1, () -> {
			spawnItem(helper, class_1802.field_8188);
		}).method_36077(10, () -> {
			helper.method_35969(BotaniaFlowerBlocks.pureDaisy.method_8389(), APOTHECARY.method_10084(), 1.5);
			fillApothecary(helper);
			// Remove the pure daisy craft result
			helper.method_36001();

			// Drop new seeds which should not enter the apothecary because of the stored recipe
			spawnItem(helper, class_1802.field_8188);
			spawnItem(helper, class_1802.field_8706);
		}).method_36077(10, () -> {
			helper.method_35969(class_1802.field_8706, APOTHECARY.method_10084(), 1.5);
			helper.method_35969(class_1802.field_8188, APOTHECARY.method_10084(), 1.5);

			// Drop an item which will enter the apothecary, which will clear the recipe and allow the seeds to enter
			spawnItem(helper, class_1802.field_8477);
		}).method_36077(10, () -> {
			// Kill all items (which should be none) and destroy apothecary to have only its contents as dropped items
			helper.method_36001();
			helper.method_36044(APOTHECARY);

			helper.method_35969(class_1802.field_8706, APOTHECARY, 1.5);
			helper.method_35969(class_1802.field_8188, APOTHECARY, 1.5);
			helper.method_35969(class_1802.field_8477, APOTHECARY, 1.5);

			helper.method_36001();
		}).method_36075();
	}

}
