/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.StoneOfTemperanceItem;

public class RingOfChordataItem extends BaubleItem {

	private static final int MANA_COST = 3;
	private static final int CONDUIT_POWER_AMPLIFIER = 0;
	private static final int DOLPHINS_GRACE_AMPLIFIER = 0;
	private static final int OUT_OF_MANA_DURATION = 60;

	public RingOfChordataItem(class_1793 props) {
		super(props);
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		if (!(living instanceof class_1657 player) || player.method_37908().field_9236) {
			return;
		}
		if (player.method_5816()) {
			// only activate for one ring at a time
			class_1799 result = EquipmentHandler.findOrEmpty(BotaniaItems.waterRing, living);
			if (result != stack) {
				return;
			}

			boolean hasMana = ManaItemHandler.instance().requestManaExact(stack, player, MANA_COST, false);
			if (hasMana) {
				EntityHelper.addStaticEffect(living, class_1294.field_5927, CONDUIT_POWER_AMPLIFIER);

				if (StoneOfTemperanceItem.hasTemperanceActive(player)) {
					EntityHelper.removeStaticEffect(living, class_1294.field_5900, DOLPHINS_GRACE_AMPLIFIER);
				} else {
					EntityHelper.addStaticEffect(living, class_1294.field_5900, DOLPHINS_GRACE_AMPLIFIER);
				}
				ManaItemHandler.instance().requestManaExact(stack, player, MANA_COST, true);
			} else {
				// convert to short finite duration to prevent flickering and other weird behavior in cases where the
				// player is out of mana and an aura band causes the ring to temporarily turn one in short intervals
				EntityHelper.convertStaticEffectToFinite(living, class_1294.field_5927, CONDUIT_POWER_AMPLIFIER,
						OUT_OF_MANA_DURATION);
				EntityHelper.convertStaticEffectToFinite(living, class_1294.field_5900,
						DOLPHINS_GRACE_AMPLIFIER, OUT_OF_MANA_DURATION);
			}
		} else {
			onUnequipped(stack, living);
		}
	}

	@Override
	public void onEquipped(class_1799 stack, class_1309 living) {
		if (living instanceof class_1657 player && player.method_5816()
				&& ManaItemHandler.instance().requestManaExact(stack, player, MANA_COST, false)) {
			EntityHelper.addStaticEffect(living, class_1294.field_5927, CONDUIT_POWER_AMPLIFIER);
			if (!StoneOfTemperanceItem.hasTemperanceActive(player)) {
				EntityHelper.addStaticEffect(living, class_1294.field_5900, DOLPHINS_GRACE_AMPLIFIER);
			}
		}
	}

	@Override
	public void onUnequipped(class_1799 stack, class_1309 living) {
		EntityHelper.removeStaticEffect(living, class_1294.field_5927, CONDUIT_POWER_AMPLIFIER);
		EntityHelper.removeStaticEffect(living, class_1294.field_5900, DOLPHINS_GRACE_AMPLIFIER);
	}

}
