/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import ;
import com.google.common.base.Predicates;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.mixin.HurtByTargetGoalAccessor;
import vazkii.botania.mixin.MobAccessor;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1355;
import net.minecraft.class_1399;
import net.minecraft.class_1569;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_4135;

public class HeiseiDreamBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int RANGE = 5;
	private static final int COST = 100;

	public HeiseiDreamBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.HEISEI_DREAM, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		List<class_1308> mobs = method_10997().method_8390(class_1308.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)), Predicates.instanceOf(class_1569.class));

		if (mobs.size() > 1 && getMana() >= COST) {
			for (class_1308 mob : mobs) {
				if (brainwashEntity(mob, mobs)) {
					addMana(-COST);
					sync();
					break;
				}
			}
		}
	}

	public static boolean brainwashEntity(class_1308 entity, List<class_1308> mobs) {
		class_1309 target = entity.method_5968();
		boolean did = false;

		if (!(target instanceof class_1569)) {
			class_1308 newTarget;
			do {
				newTarget = mobs.get(entity.method_37908().field_9229.method_43048(mobs.size()));
			} while (newTarget == entity);

			entity.method_5980(null);

			// Move any HurtByTargetGoal to highest priority
			class_1355 targetSelector = ((MobAccessor) entity).getTargetSelector();
			for (class_4135 entry : targetSelector.method_35115()) {
				if (entry.method_19058() instanceof class_1399 goal) {
					// Remove all ignorals. We can't actually resize or overwrite
					// the array, but we can fill it with classes that will never pass
					// the game logic's checks.
					var ignoreClasses = ((HurtByTargetGoalAccessor) goal).getIgnoreDamageClasses();
					Arrays.fill(ignoreClasses, Void.TYPE);

					// Concurrent modification OK since we break out of the loop
					targetSelector.method_6280(goal);
					targetSelector.method_6277(-1, goal);
					break;
				}
			}

			// Now set last hurt by, which HurtByTargetGoal will pick up
			entity.method_6015(newTarget);
			did = true;
		}

		return did;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0xFF219D;
	}

	@Override
	public int getMaxMana() {
		return 1000;
	}

}
