package vazkii.botania.test.item.lens;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2453;
import net.minecraft.class_3218;
import net.minecraft.class_4516;
import net.minecraft.class_6300;
import net.minecraft.class_6301;
import net.minecraft.class_6302;
import net.minecraft.gametest.framework.*;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.DelegatingConfigAccess;
import vazkii.botania.test.TestingUtil;
import vazkii.botania.xplat.BotaniaConfig;

public class BoreLensTest {
	private static final String ARENA = "botania:item/lens/lens_mine";
	private static final String WOOD_LEVEL_BATCH = "botania:lens_mine_test_mining_level_0";
	private static final String STONE_LEVEL_BATCH = "botania:lens_mine_test_mining_level_1";
	private static final String IRON_LEVEL_BATCH = "botania:lens_mine_test_mining_level_2";
	private static final String DIAMOND_LEVEL_BATCH = "botania:lens_mine_test_mining_level_3";

	private void mockMiningLevel(int level) {
		BotaniaConfig.setCommon(new DelegatingConfigAccess(BotaniaConfig.common()) {
			@Override
			public int harvestLevelBore() {
				return level;
			}
		});
	}

	private void restoreConfig() {
		BotaniaConfig.setCommon(((DelegatingConfigAccess) BotaniaConfig.common()).getInner());
	}

	@class_6301(method_35931 = WOOD_LEVEL_BATCH)
	public void beforeWoodBatch(class_3218 level) {
		mockMiningLevel(0);
	}

	@class_6301(method_35931 = STONE_LEVEL_BATCH)
	public void beforeStoneBatch(class_3218 level) {
		mockMiningLevel(1);
	}

	@class_6301(method_35931 = IRON_LEVEL_BATCH)
	public void beforeIronBatch(class_3218 level) {
		mockMiningLevel(2);
	}

	@class_6301(method_35931 = DIAMOND_LEVEL_BATCH)
	public void beforeDiamondBatch(class_3218 level) {
		mockMiningLevel(3);
	}

	@class_6300(method_35930 = WOOD_LEVEL_BATCH)
	public void afterWoodBatch(class_3218 level) {
		restoreConfig();
	}

	@class_6300(method_35930 = STONE_LEVEL_BATCH)
	public void afterStoneBatch(class_3218 level) {
		restoreConfig();
	}

	@class_6300(method_35930 = IRON_LEVEL_BATCH)
	public void afterIronBatch(class_3218 level) {
		restoreConfig();
	}

	@class_6300(method_35930 = DIAMOND_LEVEL_BATCH)
	public void afterDiamondBatch(class_3218 level) {
		restoreConfig();
	}

	private void testMine(class_4516 helper, class_2248 toMine, boolean expectSuccess) {
		var spreaderPos = new class_2338(1, 2, 0);
		var manaVoidPos = new class_2338(1, 2, 3);
		var lampPos = new class_2338(2, 2, 2);
		var buttonPos = new class_2338(2, 2, 0);
		var testPos = new class_2338(1, 2, 1);
		var player = helper.method_36021();

		// Because Mojang removed the block entity rotation methods, we need to ensure
		// that the spreader is pointed at the mana void properly, in case the test
		// structure is placed rotated.
		var spreader = TestingUtil.assertBlockEntity(helper, spreaderPos, BotaniaBlockEntities.SPREADER);
		TestingUtil.assertThat(spreader.bindTo(player, new class_1799(BotaniaItems.twigWand), helper.method_36052(manaVoidPos), class_2350.field_11036),
				() -> "Failed to bind spreader");
		helper.method_35984(testPos, toMine);

		if (expectSuccess) {
			helper.method_36041()
					.method_36077(1, () -> helper.method_36026(buttonPos))
					.method_36079(() -> helper.method_35987(lampPos, class_2453.field_11413, true))
					.method_36075();
		} else {
			// todo can we use failIf or something else that doesn't hardcode a tick count?
			helper.method_36041()
					.method_36077(1, () -> helper.method_36026(buttonPos))
					.method_36084(60, () -> helper.method_35987(lampPos, class_2453.field_11413, false))
					.method_36075();
		}
	}

	@class_6302(method_35936 = ARENA, method_35933 = WOOD_LEVEL_BATCH)
	public void testSnow(class_4516 helper) {
		testMine(helper, class_2246.field_10491, true);
	}

	@class_6302(method_35936 = ARENA, method_35933 = WOOD_LEVEL_BATCH)
	public void testStone(class_4516 helper) {
		testMine(helper, class_2246.field_10340, true);
	}

	@class_6302(method_35936 = ARENA, method_35933 = WOOD_LEVEL_BATCH)
	public void testLog(class_4516 helper) {
		testMine(helper, class_2246.field_10431, true);
	}

	@class_6302(method_35936 = ARENA, method_35933 = WOOD_LEVEL_BATCH)
	public void testIronBlockTooLow(class_4516 helper) {
		testMine(helper, class_2246.field_10085, false);
	}

	@class_6302(method_35936 = ARENA, method_35933 = STONE_LEVEL_BATCH)
	public void testIronBlock(class_4516 helper) {
		testMine(helper, class_2246.field_10085, true);
	}

	@class_6302(method_35936 = ARENA, method_35933 = STONE_LEVEL_BATCH)
	public void testGoldOreTooLow(class_4516 helper) {
		testMine(helper, class_2246.field_10571, false);
	}

	@class_6302(method_35936 = ARENA, method_35933 = IRON_LEVEL_BATCH)
	public void testGoldOre(class_4516 helper) {
		testMine(helper, class_2246.field_10571, true);
	}

	@class_6302(method_35936 = ARENA, method_35933 = IRON_LEVEL_BATCH)
	public void testObsidianTooLow(class_4516 helper) {
		testMine(helper, class_2246.field_10540, false);
	}

	@class_6302(method_35936 = ARENA, method_35933 = DIAMOND_LEVEL_BATCH)
	public void testObsidian(class_4516 helper) {
		testMine(helper, class_2246.field_10540, true);
	}
}
