package vazkii.botania.fabric.integration.corporea;

import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaNodeDetector;
import vazkii.botania.api.corporea.CorporeaSpark;

public class FabricTransferCorporeaNodeDetector implements CorporeaNodeDetector {
	@Nullable
	@Override
	public CorporeaNode getNode(class_1937 world, CorporeaSpark spark) {
		var inv = ItemStorage.SIDED.find(world, spark.getAttachPos(), class_2350.field_11036);
		if (inv != null && inv.supportsExtraction()) {
			return new FabricTransferCorporeaNode(world, spark.getAttachPos(), inv, spark);
		}
		return null;
	}
}
