/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.CompositableLensItem;
import vazkii.botania.common.lib.BotaniaTags;

public class CompositeLensRecipe extends class_1852 {
	public static final NoOpRecipeSerializer<CompositeLensRecipe> SERIALIZER = new NoOpRecipeSerializer<>(CompositeLensRecipe::new);

	public CompositeLensRecipe(class_2960 id) {
		super(id, class_7710.field_40249);
	}

	@Override
	public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 world) {
		boolean foundLens = false;
		boolean foundSecondLens = false;
		boolean foundGlue = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof CompositableLensItem && !foundSecondLens) {
					if (foundLens) {
						foundSecondLens = true;
					} else {
						foundLens = true;
					}
				} else if (stack.method_31573(BotaniaTags.Items.LENS_GLUE) && !foundGlue) {
					foundGlue = true;
				} else {
					return false; // Found an invalid or extra item, breaking the recipe
				}
			}
		}

		return foundSecondLens && foundGlue;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_8566 inv, @NotNull class_5455 registries) {
		class_1799 lens = class_1799.field_8037;
		class_1799 secondLens = class_1799.field_8037;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof CompositableLensItem) {
					if (lens.method_7960()) {
						lens = stack;
					} else {
						secondLens = stack;
					}
				}
			}
		}

		if (lens.method_7909() instanceof CompositableLensItem lensItem) {
			if (secondLens.method_7960() || !lensItem.canCombineLenses(lens, secondLens) || !lensItem.getCompositeLens(lens).method_7960() || !lensItem.getCompositeLens(secondLens).method_7960()) {
				return class_1799.field_8037;
			}

			class_1799 lensCopy = lens.method_46651(1);
			class_1799 secondCopy = secondLens.method_46651(1);
			lensItem.setCompositeLens(lensCopy, secondCopy);

			return lensCopy;
		}

		return class_1799.field_8037;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 3;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
