/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.block.PetalApothecary.State;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.rod.SeasRodItem;
import vazkii.botania.xplat.XplatAbstractions;

public class PetalApothecaryBlock extends BotaniaBlock implements class_2343 {

	public static final class_2754<State> FLUID = class_2754.method_11850("fluid", State.class);
	private static final class_265 BASE = class_2248.method_9541(2, 0, 2, 14, 2, 14);
	private static final class_265 PILLAR = class_2248.method_9541(4, 2, 4, 12, 11, 12);
	private static final class_265 TOP = class_2248.method_9541(2, 11, 2, 14, 16, 14);
	private static final class_265 TOP_CUTOUT = class_2248.method_9541(3, 12, 3, 13, 16, 13);
	private static final class_265 SHAPE_INTERACT = class_259.method_1084(class_259.method_1084(BASE, PILLAR), TOP);
	private static final class_265 SHAPE = class_259.method_1072(SHAPE_INTERACT, TOP_CUTOUT, class_247.field_16886);

	public enum Variant {
		DEFAULT,
		FOREST,
		PLAINS,
		MOUNTAIN,
		FUNGAL,
		SWAMP,
		DESERT,
		TAIGA,
		MESA,
		MOSSY,
		LIVINGROCK,
		DEEPSLATE
	}

	public final Variant variant;

	protected PetalApothecaryBlock(Variant v, class_4970.class_2251 builder) {
		super(builder);
		this.variant = v;
		method_9590(method_9564().method_11657(FLUID, State.EMPTY));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(FLUID);
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@NotNull
	@Override
	public class_265 method_9584(class_2680 state, class_1922 level, class_2338 pos) {
		return SHAPE_INTERACT;
	}

	@Override
	public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
		if (!world.field_9236 && entity instanceof class_1542 itemEntity) {
			PetalApothecaryBlockEntity tile = (PetalApothecaryBlockEntity) world.method_8321(pos);
			if (tile.collideEntityItem(itemEntity)) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
			}
		}
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		if (!(world.method_8321(pos) instanceof PetalApothecaryBlockEntity apothecary)) {
			return class_1269.field_5811;
		}
		boolean mainHandEmpty = player.method_6047().method_7960();

		if (apothecary.canAddLastRecipe() && mainHandEmpty) {
			return apothecary.trySetLastRecipe(player);
		} else if (!apothecary.isEmpty() && mainHandEmpty) {
			InventoryHelper.withdrawFromInventory(apothecary, player);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(apothecary);
			return class_1269.method_29236(world.method_8608());
		} else if (tryWithdrawFluid(player, hand, apothecary, pos) || tryDepositFluid(player, hand, apothecary, pos)) {
			return class_1269.method_29236(world.method_8608());
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
		if (world.field_9229.method_43048(20) == 1) {
			if (state.method_11654(FLUID) == State.EMPTY) {
				world.method_8501(pos, state.method_11657(FLUID, State.WATER));
				world.method_33596(null, class_5712.field_28733, pos);
			}
		}
	}

	private boolean tryWithdrawFluid(class_1657 player, class_1268 hand, PetalApothecaryBlockEntity altar, class_2338 pos) {
		class_3611 fluid = altar.getFluid().asVanilla();
		if (fluid == class_3612.field_15906 || fluid == class_3612.field_15910 && XplatAbstractions.INSTANCE.gogLoaded()) {
			return false;
		}

		boolean success = XplatAbstractions.INSTANCE.insertFluidIntoPlayerItem(player, hand, fluid);
		if (success) {
			altar.setFluid(PetalApothecary.State.EMPTY);
			// Usage of vanilla sound events: Subtitle is "Bucket fills"
			if (fluid == class_3612.field_15910) {
				player.method_37908().method_8396(player, pos, class_3417.field_15126, class_3419.field_15245, 1F, 1F);
			} else if (fluid == class_3612.field_15908) {
				player.method_37908().method_8396(player, pos, class_3417.field_15202, class_3419.field_15245, 1F, 1F);
			}
		}
		return success;
	}

	private boolean tryDepositFluid(class_1657 player, class_1268 hand, PetalApothecaryBlockEntity altar, class_2338 pos) {
		if (altar.getFluid() != State.EMPTY) {
			return false;
		}

		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960()
				&& stack.method_31574(BotaniaItems.waterRod)
				&& ManaItemHandler.instance().requestManaExact(stack, player, SeasRodItem.COST, false)) {
			ManaItemHandler.instance().requestManaExact(stack, player, SeasRodItem.COST, true);
			altar.setFluid(State.WATER);
			player.method_37908().method_8396(player, pos, class_3417.field_14834, class_3419.field_15245, 1F, 1F);
			return true;
		}

		if (XplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, class_3612.field_15910)) {
			altar.setFluid(State.WATER);
			// Usage of vanilla sound event: Subtitle is "Bucket empties"
			player.method_37908().method_8396(player, pos, class_3417.field_14834, class_3419.field_15245, 1F, 1F);
			return true;
		} else if (XplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, class_3612.field_15908)) {
			altar.setFluid(State.LAVA);
			// Usage of vanilla sound event: Subtitle is "Bucket empties"
			player.method_37908().method_8396(player, pos, class_3417.field_15010, class_3419.field_15245, 1F, 1F);
			return true;
		}
		return false;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new PetalApothecaryBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		if (level.field_9236) {
			return createTickerHelper(type, BotaniaBlockEntities.ALTAR, PetalApothecaryBlockEntity::clientTick);
		} else {
			return createTickerHelper(type, BotaniaBlockEntities.ALTAR, PetalApothecaryBlockEntity::serverTick);
		}
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		boolean blockChanged = !state.method_27852(newState.method_26204());
		if (blockChanged || newState.method_11654(FLUID) != State.WATER) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof SimpleInventoryBlockEntity inventory) {
				class_1264.method_5451(world, pos, inventory.getItemHandler());
			}
			if (blockChanged) {
				super.method_9536(state, world, pos, newState, isMoving);
			}
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return state.method_11654(FLUID) == State.WATER ? 15 : 0;
	}
}
