/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.HornItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.LivingEntityAccessor;
import vazkii.botania.mixin.MushroomCowAccessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1308;
import net.minecraft.class_1428;
import net.minecraft.class_1438;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_5147;

public class DrumBlock extends BotaniaWaterloggedBlock {

	public static final int MAX_NUM_SHEARED = 4;
	public static final int GATHER_RANGE = 10;
	public static final int MINIMUM_REMAINING_EGG_TIME = 600;
	public static final int STARTLED_EGG_TIME = 200;

	public enum Variant {
		WILD,
		GATHERING,
		CANOPY
	}

	private static final class_265 SHAPE = class_2248.method_9541(3, 1, 3, 13, 15, 13);
	private final Variant variant;

	public DrumBlock(Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	public static void gatherProduce(class_1937 world, class_2338 pos) {
		List<class_1308> mobs = world.method_8390(class_1308.class, new class_238(pos.method_10069(-GATHER_RANGE, -GATHER_RANGE, -GATHER_RANGE), pos.method_10069(GATHER_RANGE + 1, GATHER_RANGE + 1, GATHER_RANGE + 1)),
				mob -> mob.method_5805() && !BergamuteBlockEntity.isBergamuteNearby(world, mob.method_23317(), mob.method_23318(), mob.method_23321()));
		List<class_5147> shearables = new ArrayList<>();

		for (class_1308 mob : mobs) {
			if (mob instanceof class_1428 chicken && !chicken.method_6109() && !chicken.method_6472()) {
				speedUpEggLaying(chicken);
			}
			if (mob.method_5864().method_20210(BotaniaTags.Entities.DRUM_MILKABLE) && !mob.method_6109()) {
				convertNearby(mob, class_1802.field_8550, class_1802.field_8103);
			}
			if (mob instanceof class_1438 mooshroom && !mooshroom.method_6109()) {
				if (mooshroom.method_47847() == class_1438.class_4053.field_18110 && ((MushroomCowAccessor) mooshroom).getEffect() != null) {
					fillBowlSuspiciously(mooshroom);
				}
				convertNearby(mob, class_1802.field_8428, class_1802.field_8208);
			}
			if (mob instanceof class_5147 shearable && !mob.method_5864().method_20210(BotaniaTags.Entities.DRUM_NO_SHEARING) && shearable.method_27072()) {
				shearables.add(shearable);
			}
		}

		Collections.shuffle(shearables);
		int sheared = 0;

		for (class_5147 shearable : shearables) {
			if (sheared > MAX_NUM_SHEARED) {
				break;
			}

			shearable.method_6636(class_3419.field_15245);
			++sheared;
		}
	}

	private static void speedUpEggLaying(class_1428 chicken) {
		if (chicken.field_6739 > MINIMUM_REMAINING_EGG_TIME) {
			chicken.field_6739 = Math.max(MINIMUM_REMAINING_EGG_TIME, chicken.field_6739 / 2);
		} else if (chicken.field_6739 < STARTLED_EGG_TIME && chicken.field_6739 > 1) {
			chicken.field_6739 = 1;
			((LivingEntityAccessor) chicken).botania_playHurtSound(chicken.method_48923().method_48831());
		}
	}

	private static void convertNearby(class_1308 mob, class_1792 from, class_1792 to) {
		class_1937 world = mob.method_37908();
		List<class_1542> fromEntities = world.method_8390(class_1542.class, mob.method_5829(),
				itemEntity -> itemEntity.method_5805() && itemEntity.method_6983().method_31574(from));
		for (class_1542 fromEntity : fromEntities) {
			class_1799 fromStack = fromEntity.method_6983();
			for (int i = fromStack.method_7947(); i > 0; i--) {
				spawnItem(mob, new class_1799(to));
			}
			fromEntity.method_31472();
		}
	}

	private static void spawnItem(class_1308 mob, class_1799 to) {
		class_1937 world = mob.method_37908();
		class_1542 ent = mob.method_5699(to, 1.0F);
		ent.method_18799(ent.method_18798().method_1031(
				world.field_9229.method_43057() * 0.05F,
				(world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.1F,
				(world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.1F
		));
	}

	private static void fillBowlSuspiciously(class_1438 mushroomCow) {
		MushroomCowAccessor mushroomCowAccessor = (MushroomCowAccessor) mushroomCow;
		class_1291 effect = mushroomCowAccessor.getEffect();
		int effectDuration = mushroomCowAccessor.getEffectDuration();

		class_1937 world = mushroomCow.method_37908();
		List<class_1542> bowlItemEntities = world.method_8390(class_1542.class, mushroomCow.method_5829(),
				itemEntity -> itemEntity.method_6983().method_31574(class_1802.field_8428) && !itemEntity.method_6983().method_7960());
		for (class_1542 bowlItemEntity : bowlItemEntities) {
			class_1799 bowlItem = bowlItemEntity.method_6983();
			class_1799 stewItem = new class_1799(class_1802.field_8766);
			class_1830.method_8021(stewItem, effect, effectDuration);
			spawnItem(mushroomCow, stewItem);

			EntityHelper.shrinkItem(bowlItemEntity);
			if (bowlItem.method_7947() == 0) {
				bowlItemEntity.method_31472();
			}

			// only one suspicious stew per flower fed
			mushroomCowAccessor.setEffect(null);
			mushroomCowAccessor.setEffectDuration(0);
			break;
		}
	}

	public static class ManaTriggerImpl implements ManaTrigger {
		private final class_1937 world;
		private final class_2338 pos;
		private final Variant variant;

		public ManaTriggerImpl(class_1937 world, class_2338 pos, class_2680 state) {
			this.world = world;
			this.pos = pos;
			this.variant = ((DrumBlock) state.method_26204()).variant;
		}

		@Override
		public void onBurstCollision(ManaBurst burst) {
			if (burst.isFake()) {
				return;
			}
			if (world.field_9236) {
				world.method_8406(class_2398.field_11224, pos.method_10263() + 0.5, pos.method_10264() + 1.2, pos.method_10260() + 0.5D, 1.0 / 24.0, 0, 0);
				return;
			}
			switch (variant) {
				case WILD -> HornItem.breakGrass(world, new class_1799(BotaniaItems.grassHorn), pos, null);
				case CANOPY -> HornItem.breakGrass(world, new class_1799(BotaniaItems.leavesHorn), pos, null);
				case GATHERING -> gatherProduce(world, pos);
			}

			for (int i = 0; i < 10; i++) {
				world.method_8396(null, pos, BotaniaSounds.drum, class_3419.field_15245, 1F, 1F);
			}
		}
	}
}
