/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_7923;

public class BlackHoleTalismanItem extends class_1792 {
	public static final String TAG_ACTIVE = "active";
	public static final String TAG_BLOCK_NAME = "blockName";
	public static final String TAG_BLOCK_COUNT = "blockCount";

	public BlackHoleTalismanItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (getBlock(stack) != null && player.method_21823()) {
			ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
			player.method_5783(BotaniaSounds.blackHoleTalismanConfigure, 1F, 1F);
			return class_1271.method_29237(stack, world.method_8608());
		}

		return class_1271.method_22430(stack);
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_2338 pos = ctx.method_8037();
		class_2350 side = ctx.method_8038();
		class_1657 player = ctx.method_8036();
		class_2680 state = world.method_8320(pos);
		class_1799 stack = ctx.method_8041();

		if (!state.method_26215() && setBlock(stack, state.method_26204())) {
			return class_1269.method_29236(world.method_8608());
		} else {
			class_2248 bBlock = getBlock(stack);

			if (bBlock == null) {
				return class_1269.field_5811;
			}

			class_2586 tile = world.method_8321(pos);
			if (tile instanceof class_1263 container) {
				if (!world.field_9236) {
					class_1799 toAdd = new class_1799(bBlock);
					int maxSize = toAdd.method_7914();
					toAdd.method_7939(remove(stack, maxSize));
					class_1799 remainder = class_2614.method_11260(null, container, toAdd, side);
					if (!remainder.method_7960()) {
						add(stack, remainder.method_7947());
					}
				}
				return class_1269.method_29236(world.method_8608());
			} else {
				if (player == null || player.method_31549().field_7477 || getBlockCount(stack) > 0) {
					class_1799 toUse = new class_1799(bBlock);
					class_1269 result = PlayerHelper.substituteUse(ctx, toUse);

					if (result.method_23665()) {
						if (!world.field_9236) {
							remove(stack, 1);
							ItemsRemainingRenderHandler.send(player, toUse, getBlockCount(stack));
						}
						return result;
					}
				}
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_7888(class_1799 itemstack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		class_2248 block = getBlock(itemstack);
		if (!entity.method_37908().field_9236 && ItemNBTHelper.getBoolean(itemstack, TAG_ACTIVE, false) && block != null) {
			if (entity instanceof class_1657 player) {
				suckFromPlayerInv(itemstack, block, player);
			}
		}
	}

	private static void suckFromPlayerInv(class_1799 talisman, class_2248 toTake, class_1657 player) {
		int highestIdx = -1;
		int[] counts = new int[player.method_31548().method_5439() - player.method_31548().field_7548.size()];

		for (int i = 0; i < counts.length; i++) {
			class_1799 stack = player.method_31548().method_5438(i);
			if (stack.method_7960()) {
				continue;
			}

			if (toTake.method_8389() == stack.method_7909()
					&& (stack.method_7969() == null || stack.method_7969().method_33133())) {
				counts[i] = stack.method_7947();
				if (highestIdx == -1) {
					highestIdx = i;
				} else {
					highestIdx = counts[i] > counts[highestIdx] && highestIdx > 8 ? i : highestIdx;
				}
			}
		}

		if (highestIdx != -1) {
			for (int i = 0; i < counts.length; i++) {
				int count = counts[i];

				if (count == 0) {
					continue;
				}

				add(talisman, count);
				player.method_31548().method_5447(i, class_1799.field_8037);
			}
		}
	}

	@NotNull
	@Override
	public class_2561 method_7864(@NotNull class_1799 stack) {
		class_2248 block = getBlock(stack);
		class_1799 bstack = block == null ? class_1799.field_8037 : new class_1799(block);
		class_5250 cand = super.method_7864(stack).method_27661();

		if (!bstack.method_7960()) {
			cand.method_27693(" (");
			cand.method_10852(bstack.method_7964().method_27661().method_27692(class_124.field_1060));
			cand.method_27693(")");
		}

		return cand;
	}

	public static boolean setBlock(class_1799 stack, class_2248 block) {
		if (block.method_8389() != class_1802.field_8162 && (getBlock(stack) == null || getBlockCount(stack) == 0)) {
			ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, class_7923.field_41175.method_10221(block).toString());
			return true;
		}
		return false;
	}

	private static void add(class_1799 stack, int count) {
		int current = getBlockCount(stack);
		setCount(stack, current + count);
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		class_2248 block = getBlock(stack);
		if (block != null) {
			int count = getBlockCount(stack);
			stacks.add(class_2561.method_43470(count + " ").method_10852(new class_1799(block).method_7964()).method_27692(class_124.field_1080));
		}

		if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
			stacks.add(class_2561.method_43471("botaniamisc.active"));
		} else {
			stacks.add(class_2561.method_43471("botaniamisc.inactive"));
		}
	}

	public static void setCount(class_1799 stack, int count) {
		ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
	}

	public static int remove(class_1799 stack, int count) {
		int current = getBlockCount(stack);
		setCount(stack, Math.max(current - count, 0));

		return Math.min(current, count);
	}

	private static String getBlockName(class_1799 stack) {
		return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
	}

	@Nullable
	public static class_2248 getBlock(class_1799 stack) {
		class_2960 id = class_2960.method_12829(getBlockName(stack));
		if (id != null) {
			return class_7923.field_41175.method_17966(id).orElse(null);
		}
		return null;
	}

	public static int getBlockCount(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
	}

	public static class BlockProviderImpl implements BlockProvider {
		private final class_1799 stack;

		public BlockProviderImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Override
		public boolean provideBlock(class_1657 player, class_1799 requestor, class_2248 block, boolean doit) {
			class_2248 stored = getBlock(stack);
			if (stored == block) {
				int count = BlackHoleTalismanItem.getBlockCount(stack);
				if (count > 0) {
					if (doit) {
						setCount(stack, count - 1);
					}
					return true;
				}
			}

			return false;
		}

		@Override
		public int getBlockCount(class_1657 player, class_1799 requestor, class_2248 block) {
			class_2248 stored = getBlock(stack);
			if (stored == block) {
				return BlackHoleTalismanItem.getBlockCount(stack);
			}
			return 0;
		}
	}

	@Override
	public boolean method_31565(@NotNull class_1799 talisman, @NotNull class_1735 slot,
			@NotNull class_5536 clickAction, @NotNull class_1657 player) {
		if (clickAction == class_5536.field_27014) {
			class_1799 toInsert = slot.method_7677();
			class_2248 blockToInsert = class_2248.method_9503(toInsert.method_7909());
			if (blockToInsert != class_2246.field_10124) {
				class_2248 existingBlock = getBlock(talisman);
				if (existingBlock == null || existingBlock == blockToInsert) {
					class_1799 taken = slot.method_32753(toInsert.method_7947(), Integer.MAX_VALUE, player);
					if (existingBlock == null) {
						setBlock(talisman, blockToInsert);
						setCount(talisman, taken.method_7947());
					} else {
						add(talisman, taken.method_7947());
					}
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public boolean method_31566(
			@NotNull class_1799 talisman, @NotNull class_1799 toInsert, @NotNull class_1735 slot,
			@NotNull class_5536 clickAction, @NotNull class_1657 player, @NotNull class_5630 cursorAccess) {
		if (clickAction == class_5536.field_27014) {
			class_2248 blockToInsert = class_2248.method_9503(toInsert.method_7909());
			if (blockToInsert != class_2246.field_10124) {
				class_2248 existingBlock = getBlock(talisman);
				if (existingBlock == null || existingBlock == blockToInsert) {
					if (existingBlock == null) {
						setBlock(talisman, blockToInsert);
						setCount(talisman, toInsert.method_7947());
					} else {
						add(talisman, toInsert.method_7947());
					}
					cursorAccess.method_32332(class_1799.field_8037);
					return true;
				}
			}
		}
		return false;
	}
}
