/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.block_entity;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.*;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.red_string.RedStringSpooferBlockEntity;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.lib.BotaniaTags;

/**
 * Common superclass of all magical flower block entities
 */
public abstract class SpecialFlowerBlockEntity extends class_2586 implements FloatingFlowerProvider {
	public static final int PODZOL_DELAY = 5;
	public static final int MYCELIUM_DELAY = 10;

	private final FloatingFlower floatingData = new FloatingFlowerImpl() {
		@Override
		public class_1799 getDisplayStack() {
			class_2960 id = class_7923.field_41181.method_10221(method_11017());
			return class_7923.field_41178.method_17966(id).map(class_1799::new).orElse(super.getDisplayStack());
		}
	};

	public int ticksExisted = 0;

	/** true if this flower is working on Enchanted Soil **/
	public boolean overgrowth = false;
	/** true if this flower is working on Enchanted Soil and this is the second tick **/
	public boolean overgrowthBoost = false;
	private class_2338 positionOverride;
	private boolean isFloating;

	public static final String TAG_TICKS_EXISTED = "ticksExisted";
	private static final String TAG_FLOATING_DATA = "floating";

	public SpecialFlowerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, SpecialFlowerBlockEntity self) {
		if (self.isFloating != state.method_26164(BotaniaTags.Blocks.FLOATING_FLOWERS)) {
			BotaniaAPI.LOGGER.error("Special flower changed floating state, this is not supported!", new Throwable());
			self.isFloating = !self.isFloating;
		}
		class_2586 tileBelow = level.method_8321(worldPosition.method_10074());
		if (tileBelow instanceof RedStringSpooferBlockEntity relay) {
			class_2338 coords = relay.getBinding();
			if (coords != null) {
				self.positionOverride = coords;
				self.tickFlower();

				return;
			} else {
				self.positionOverride = null;
			}
		} else {
			self.positionOverride = null;
		}

		boolean special = self.isOnSpecialSoil();
		if (special) {
			self.overgrowth = true;
			if (self.isOvergrowthAffected()) {
				self.tickFlower();
				self.overgrowthBoost = true;
			}
		}
		self.tickFlower();
		self.overgrowth = false;
		self.overgrowthBoost = false;
	}

	@Nullable
	@Override
	public FloatingFlower getFloatingData() {
		if (method_11002() && isFloating()) {
			return floatingData;
		}
		return null;
	}

	public final boolean isFloating() {
		return this.isFloating;
	}

	/**
	 * WARNING: This should only be called during or soon after construction.
	 * Switching between nonfloating/floating at play time is not supported and a fresh
	 * Block Entity should be created instead.
	 */
	public final void setFloating(boolean floating) {
		this.isFloating = floating;
	}

	public boolean isOnSpecialSoil() {
		if (isFloating()) {
			return false;
		} else {
			return field_11863.method_8320(field_11867.method_10074()).method_27852(BotaniaBlocks.enchantedSoil);
		}
	}

	/**
	 * @return Where this flower's effects are centered at. This can differ from the true TE location due to
	 *         red string spoofers.
	 */
	public final class_2338 getEffectivePos() {
		return positionOverride != null ? positionOverride : method_11016();
	}

	protected void tickFlower() {
		ticksExisted++;
	}

	@Override
	public final void method_11014(class_2487 cmp) {
		super.method_11014(cmp);
		if (cmp.method_10545(TAG_TICKS_EXISTED)) {
			ticksExisted = cmp.method_10550(TAG_TICKS_EXISTED);
		}
		if (method_11010().method_26204() instanceof FloatingFlowerBlock) {
			setFloating(true);
		}

		FloatingFlower.IslandType oldType = floatingData.getIslandType();
		readFromPacketNBT(cmp);
		if (isFloating() && oldType != floatingData.getIslandType() && field_11863 != null) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 0);
		}
	}

	@Override
	public final void method_11007(class_2487 cmp) {
		super.method_11007(cmp);
		cmp.method_10569(TAG_TICKS_EXISTED, ticksExisted);
		writeToPacketNBT(cmp);
	}

	@NotNull
	@Override
	public class_2487 method_16887() {
		var tag = new class_2487();
		writeToPacketNBT(tag);
		return tag;
	}

	/**
	 * Writes some extra data to a network packet. This data is read
	 * by readFromPacketNBT on the client that receives the packet.
	 * Note: This method is also used to write to the world NBT.
	 */
	public void writeToPacketNBT(class_2487 cmp) {
		if (isFloating()) {
			cmp.method_10566(TAG_FLOATING_DATA, floatingData.writeNBT());
		}
	}

	/**
	 * Reads data from a network packet. This data is written by
	 * writeToPacketNBT in the server. Note: This method is also used
	 * to read from the world NBT.
	 */
	public void readFromPacketNBT(class_2487 cmp) {
		if (cmp.method_10545(TAG_FLOATING_DATA)) {
			floatingData.readNBT(cmp.method_10562(TAG_FLOATING_DATA));
		}
	}

	@Override
	public class_2596<class_2602> method_38235() {
		return class_2622.method_38585(this);
	}

	public void sync() {
		VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
	}

	/**
	 * Called when this sub tile is placed in the world (by an entity).
	 */
	public void setPlacedBy(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {}

	/**
	 * Returns a descriptor for the radius of this sub tile. This is called while a player
	 * is looking at the block with a Manaseer Monocle.
	 */
	@Nullable
	public abstract RadiusDescriptor getRadius();

	/**
	 * Returns a descriptor for this flower's secondary radius.
	 * Use for e.g. when a flower has different ranges for picking up and using dropped items.
	 * Called when the player is looking at the block with a Manaseer Monocle.
	 */
	@Nullable
	public RadiusDescriptor getSecondaryRadius() {
		return null;
	}

	/**
	 * Gets if this SubTileEntity is affected by Enchanted Soil's speed boost.
	 */
	public boolean isOvergrowthAffected() {
		return true;
	}

	public int getComparatorSignal() {
		return 0;
	}

	/**
	 * Returns the additional delay in ticks that an item must be on the ground before this flower will act on it.
	 */
	public int getModulatedDelay() {
		if (isFloating()) {
			FloatingFlower.IslandType type = floatingData.getIslandType();
			if (type == FloatingFlower.IslandType.MYCEL) {
				return MYCELIUM_DELAY;
			} else if (type == FloatingFlower.IslandType.PODZOL) {
				return PODZOL_DELAY;
			}
		} else {
			class_2680 below = field_11863.method_8320(method_11016().method_10074());
			if (below.method_27852(class_2246.field_10402)) {
				return MYCELIUM_DELAY;
			}

			if (below.method_27852(class_2246.field_10520)) {
				return PODZOL_DELAY;
			}
		}

		return 0;
	}

	@SoftImplement("RenderDataBlockEntity")
	@Nullable
	public Object getRenderData() {
		if (isFloating()) {
			return floatingData.getIslandType();
		}
		return null;
	}

	public void emitParticle(class_2394 options, double xOffset, double yOffset, double zOffset, double xSpeed, double ySpeed, double zSpeed) {
		if (!field_11863.field_9236) {
			return;
		}
		class_243 offset = field_11863.method_8320(getEffectivePos()).method_26226(field_11863, getEffectivePos());
		field_11863.method_8406(options,
				getEffectivePos().method_10263() + offset.field_1352 + xOffset,
				getEffectivePos().method_10264() + offset.field_1351 + yOffset,
				getEffectivePos().method_10260() + offset.field_1350 + zOffset,
				xSpeed, ySpeed, zSpeed
		);
	}
}
