/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.world.phys.*;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class RedirectiveLens extends Lens {

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		class_2338 sourcePos = burst.getBurstSourceBlockPos();
		var burstEntity = burst.entity();
		if (!burstEntity.method_37908().field_9236 && !burst.isFake()) {
			if (pos instanceof class_3965 result
					&& result.method_17783() != class_239.class_240.field_1333
					&& !result.method_17777().equals(sourcePos)) {
				handleHitBlock(burst, result);
			} else if (pos instanceof class_3966 result
					&& result.method_17782() != burstEntity.method_24921()) {
				handleHitEntity(burst, result);
			}
		}

		return shouldKill;
	}

	@SuppressWarnings("deprecation")
	@Nullable
	private static class_243 getSourceVec(ManaBurst burst) {
		var entity = burst.entity();
		var owner = entity.method_24921();
		var sourcePos = burst.getBurstSourceBlockPos();
		class_1937 level = entity.method_37908();
		if (!sourcePos.equals(ManaBurst.NO_SOURCE) && burst.isBurstSourceDimension(level) && level.method_22340(sourcePos)) {
			var sourceVec = class_243.method_24953(sourcePos);
			class_238 axis;
			class_265 collideShape = level.method_8320(sourcePos).method_26220(level, sourcePos);
			if (collideShape.method_1110()) {
				axis = new class_238(sourcePos, sourcePos.method_10069(1, 1, 1));
			} else {
				axis = collideShape.method_1107().method_996(sourcePos);
			}

			if (!axis.method_1006(sourceVec)) {
				sourceVec = new class_243(axis.field_1323 + (axis.field_1320 - axis.field_1323) / 2, axis.field_1322 + (axis.field_1325 - axis.field_1322) / 2, axis.field_1321 + (axis.field_1324 - axis.field_1321) / 2);
			}
			return sourceVec;
		} else if (owner != null) {
			return owner.method_33571();
		} else {
			// No block nor entity source, should never happen but don't crash
			return null;
		}
	}

	private void handleHitEntity(ManaBurst burst, class_3966 result) {
		var sourceVec = getSourceVec(burst);
		if (sourceVec != null) {
			result.method_17782().method_5702(class_2183.class_2184.field_9851, sourceVec);
		}
	}

	private void handleHitBlock(ManaBurst burst, class_3965 result) {
		var sourceVec = getSourceVec(burst);
		if (sourceVec == null) {
			return;
		}

		var entity = burst.entity();
		var hitPos = result.method_17777();
		var receiver = XplatAbstractions.INSTANCE.findManaReceiver(entity.method_37908(), hitPos, result.method_17780());
		if (receiver instanceof ManaSpreader spreader) {
			class_243 tileVec = class_243.method_24953(hitPos);
			class_243 diffVec = sourceVec.method_1020(tileVec);
			class_243 diffVec2D = new class_243(diffVec.field_1352, diffVec.field_1350, 0);
			class_243 rotVec = new class_243(0, 1, 0);
			double angle = MathHelper.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;

			if (sourceVec.field_1352 < tileVec.field_1352) {
				angle = -angle;
			}

			spreader.setRotationX((float) angle + 90F);

			rotVec = new class_243(diffVec.field_1352, 0, diffVec.field_1350);
			angle = MathHelper.angleBetween(diffVec, rotVec) * 180F / Math.PI;
			if (sourceVec.field_1351 < tileVec.field_1351) {
				angle = -angle;
			}
			spreader.setRotationY((float) angle);

			spreader.commitRedirection();
			if (spreader instanceof ThrottledPacket pkt) {
				pkt.markDispatchable();
			}
		}
	}

}
