/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.StateIngredient;

import java.util.Collection;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class TagExcludingStateIngredient extends TagStateIngredient {
	private final List<StateIngredient> excludes;

	public TagExcludingStateIngredient(class_2960 id, Collection<StateIngredient> excludes) {
		super(id);
		this.excludes = List.copyOf(excludes);
	}

	@Override
	public boolean test(class_2680 state) {
		if (!super.test(state)) {
			return false;
		}
		return isNotExcluded(state);
	}

	private boolean isNotExcluded(class_2680 state) {
		for (StateIngredient exclude : excludes) {
			if (exclude.test(state)) {
				return false;
			}
		}
		return true;
	}

	@Override
	public boolean equals(Object o) {
		return super.equals(o) && this.excludes.equals(((TagExcludingStateIngredient) o).excludes);
	}

	@Override
	public int hashCode() {
		return super.hashCode();
	}

	@Override
	public JsonObject serialize() {
		JsonObject object = new JsonObject();
		object.addProperty("type", "tag_excluding");
		object.addProperty("tag", getTagId().toString());
		JsonArray array = new JsonArray();
		for (StateIngredient exclude : excludes) {
			array.add(exclude.serialize());
		}
		object.add("exclude", array);
		return object;
	}

	@Override
	public List<class_1799> getDisplayedStacks() {
		return getBlocks().stream()
				.filter(b -> b.method_8389() != class_1802.field_8162)
				.map(class_1799::new)
				.toList();
	}

	@NotNull
	@Override
	public List<class_2248> getBlocks() {
		return super.getBlocks().stream()
				.filter(b -> isNotExcluded(b.method_9564()))
				.toList();
	}

	@Override
	public List<class_2680> getDisplayed() {
		return super.getDisplayed().stream()
				.filter(this::isNotExcluded)
				.toList();
	}
}
