/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaPoolBlockEntityRenderer
implements class_827<ManaPoolBlockEntity> {
    public static int cartMana = -1;
    private final class_1058 waterSprite;
    private final class_776 blockRenderDispatcher;

    public ManaPoolBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.blockRenderDispatcher = ctx.method_32141();
        this.waterSprite = Objects.requireNonNull((class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(ResourceLocationHelper.prefix("block/mana_water")));
    }

    public void render(@Nullable ManaPoolBlockEntity pool, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
        float manaLevel;
        int maxMana;
        class_2248 below;
        ms.method_22903();
        boolean fab = pool != null && ((ManaPoolBlock)pool.method_11010().method_26204()).variant == ManaPoolBlock.Variant.FABULOUS;
        boolean diluted = pool != null && ((ManaPoolBlock)pool.method_11010().method_26204()).variant == ManaPoolBlock.Variant.DILUTED;
        boolean creative = pool != null && ((ManaPoolBlock)pool.method_11010().method_26204()).variant == ManaPoolBlock.Variant.CREATIVE;
        int insideUVStart = diluted ? 1 : 2;
        int insideUVEnd = 16 - insideUVStart;
        float poolBottom = (float)insideUVStart / 16.0f + 0.001f;
        float poolTop = (float)(diluted ? 5 : (creative ? 9 : 7)) / 16.0f;
        if (fab) {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            time += (float)new Random(pool.method_11016().method_10263() ^ pool.method_11016().method_10264() ^ pool.method_11016().method_10260()).nextInt(100000);
            int poolColor = pool.getColor().map(ColorHelper::getColorValue).orElse(-1);
            int color = MathHelper.multiplyColor(class_3532.method_15369((float)class_3532.method_22450((float)(time *= 0.005f)), (float)0.6f, (float)1.0f), poolColor);
            int red = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int blue = color & 0xFF;
            class_2680 state = pool.method_11010();
            class_1087 model = this.blockRenderDispatcher.method_3349(state);
            class_4588 buffer = buffers.getBuffer(class_4696.method_23683((class_2680)state, (boolean)false));
            this.blockRenderDispatcher.method_3350().method_3367(ms.method_23760(), buffer, state, model, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, light, overlay);
        }
        if (pool != null && (below = pool.method_10997().method_8320(pool.method_11016().method_10074()).method_26204()) instanceof PoolOverlayProvider) {
            PoolOverlayProvider overlayProvider = (PoolOverlayProvider)below;
            class_2960 overlaySpriteId = overlayProvider.getIcon(pool.method_10997(), pool.method_11016());
            class_1058 overlayIcon = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(overlaySpriteId);
            ms.method_22903();
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2);
            ms.method_46416(0.0f, poolBottom, 0.0f);
            ms.method_22907(VecHelper.rotateX(90.0f));
            class_4588 buffer = buffers.getBuffer(RenderHelper.ICON_OVERLAY);
            RenderHelper.renderIconCropped(ms, buffer, insideUVStart, insideUVStart, insideUVEnd, insideUVEnd, overlayIcon, 0xFFFFFF, alpha, light);
            ms.method_22909();
        }
        int mana = pool == null ? cartMana : pool.getCurrentMana();
        int n = maxMana = pool == null ? -1 : pool.getMaxMana();
        if (maxMana == -1) {
            maxMana = 1000000;
        }
        if ((manaLevel = (float)mana / (float)maxMana) > 0.0f) {
            ms.method_22903();
            ms.method_46416(0.0f, class_3532.method_37958((float)manaLevel, (float)0.0f, (float)1.0f, (float)poolBottom, (float)poolTop), 0.0f);
            ms.method_22907(VecHelper.rotateX(90.0f));
            class_4588 buffer = buffers.getBuffer(RenderHelper.MANA_POOL_WATER);
            RenderHelper.renderIconCropped(ms, buffer, insideUVStart, insideUVStart, insideUVEnd, insideUVEnd, this.waterSprite, 0xFFFFFF, 1.0f, light);
            ms.method_22909();
        }
        ms.method_22909();
        cartMana = -1;
    }
}

