/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5712;
import net.minecraft.class_6862;

public abstract class FluidGeneratorBlockEntity extends GeneratingFlowerBlockEntity {
	private static final String TAG_BURN_TIME = "burnTime";
	public static final String TAG_COOLDOWN = "cooldown";

	private static final class_2338[] OFFSETS = { new class_2338(0, 0, 1), new class_2338(0, 0, -1), new class_2338(1, 0, 0), new class_2338(-1, 0, 0), new class_2338(-1, 0, 1), new class_2338(-1, 0, -1), new class_2338(1, 0, 1), new class_2338(1, 0, -1) };

	public static final int DECAY_TIME = 72000;
	protected int burnTime, cooldown;
	private final class_6862<class_3611> consumedFluid;
	private final int startBurnTime, manaPerTick;

	protected FluidGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, class_6862<class_3611> consumedFluid, int startBurnTime, int manaPerTick) {
		super(type, pos, state);
		this.consumedFluid = consumedFluid;
		this.startBurnTime = startBurnTime;
		this.manaPerTick = manaPerTick;
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (cooldown > 0) {
			cooldown--;
			for (int i = 0; i < 3; i++) {
				WispParticleData data = WispParticleData.wisp((float) Math.random() / 6, 0.1F, 0.1F, 0.1F, 1);
				emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0, (float) Math.random() / 30, 0);
			}
		}

		if (!method_10997().field_9236) {
			if (burnTime > 0 && ticksExisted % getGenerationDelay() == 0) {
				addMana(manaPerTick);
				sync();
			}
		}

		if (burnTime == 0) {
			if (getMana() < getMaxMana() && !method_10997().field_9236) {
				List<class_2338> offsets = Arrays.asList(OFFSETS);
				Collections.shuffle(offsets);

				for (class_2338 offset : offsets) {
					class_2338 pos = getEffectivePos().method_10081(offset);

					class_2680 bstate = method_10997().method_8320(pos);
					class_3610 fstate = method_10997().method_8316(pos);
					if (fstate.method_15767(consumedFluid) && fstate.method_15771()) {
						if (consumedFluid != class_3486.field_15517) {
							method_10997().method_8501(pos, class_2246.field_10124.method_9564());
						} else {
							int waterAround = 0;
							for (class_2350 dir : class_2350.values()) {
								if (method_10997().method_8316(pos.method_10093(dir)).method_15767(consumedFluid)) {
									waterAround++;
								}
							}

							if (waterAround < 2) {
								if (bstate.method_26204() instanceof class_2263 bucketPickup) {
									bucketPickup.method_9700(method_10997(), pos, bstate);
								} else {
									method_10997().method_8501(pos, class_2246.field_10124.method_9564());
								}
								method_10997().method_33596(null, class_5712.field_28167, pos);
							}
						}

						if (cooldown == 0) {
							burnTime += startBurnTime;
							method_10997().method_33596(null, class_5712.field_28174, method_11016());
						} else {
							cooldown = getCooldownTime(false);
						}

						method_5431();
						sync();
						playSound();
						break;
					}
				}
			}
		} else {
			if (method_10997().field_9229.method_43048(8) == 0) {
				doBurnParticles();
			}
			burnTime--;
			if (burnTime == 0) {
				cooldown = getCooldownTime(true);
				method_10997().method_33596(null, class_5712.field_28175, method_11016());
				method_5431();
				sync();
			}
		}
	}

	public abstract int getCooldownTime(boolean finishedPrevious);

	public int getGenerationDelay() {
		return 1;
	}

	public abstract void doBurnParticles();

	public abstract void playSound();

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_BURN_TIME, burnTime);
		cmp.method_10569(TAG_COOLDOWN, cooldown);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		burnTime = cmp.method_10550(TAG_BURN_TIME);
		cooldown = cmp.method_10550(TAG_COOLDOWN);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), 1);
	}
}
