package vazkii.botania.client.render;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.lib.LibMisc;

import java.util.function.BiConsumer;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2521;
import net.minecraft.class_7923;

public final class BlockRenderLayers {
	public static boolean skipPlatformBlocks;

	public static void init(BiConsumer<class_2248, class_1921> consumer) {
		consumer.accept(BotaniaBlocks.defaultAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.forestAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.plainsAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.mountainAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.fungalAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.swampAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.desertAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.taigaAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.mesaAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.mossyAltar, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.ghostRail, class_1921.method_23581());
		consumer.accept(BotaniaBlocks.solidVines, class_1921.method_23581());

		consumer.accept(BotaniaBlocks.corporeaCrystalCube, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.manaGlass, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.managlassPane, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.elfGlass, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.alfglassPane, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.bifrost, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.bifrostPane, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.bifrostPerm, class_1921.method_23583());
		consumer.accept(BotaniaBlocks.prism, class_1921.method_23583());

		consumer.accept(BotaniaBlocks.starfield, class_1921.method_23579());
		if (!skipPlatformBlocks) {
			// Render type is set dynamically on Forge and undisguised platforms should render as "solid",
			// but "translucent" is the best compromise on Fabric.
			// Translucent comes with a couple of downsides, like hidden block breaking animation and bad
			// Z-ordering for non-cubic block models that should be rendered with the "cutout" render type.
			consumer.accept(BotaniaBlocks.abstrusePlatform, class_1921.method_23583());
			consumer.accept(BotaniaBlocks.infrangiblePlatform, class_1921.method_23583());
			consumer.accept(BotaniaBlocks.spectralPlatform, class_1921.method_23583());
		}
		class_7923.field_41175.method_10220().filter(b -> class_7923.field_41175.method_10221(b).method_12836().equals(LibMisc.MOD_ID))
				.forEach(b -> {
					if (b instanceof FloatingFlowerBlock || b instanceof class_2356
							|| b instanceof class_2521 || b instanceof BotaniaMushroomBlock
							|| b instanceof class_2362) {
						consumer.accept(b, class_1921.method_23581());
					}
				});
	}

	private BlockRenderLayers() {}
}
